/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mls.codec;

import java.io.IOException;
import org.bouncycastle.mls.codec.Commit;
import org.bouncycastle.mls.codec.ContentType;
import org.bouncycastle.mls.codec.MLSInputStream;
import org.bouncycastle.mls.codec.MLSOutputStream;
import org.bouncycastle.mls.codec.Proposal;
import org.bouncycastle.mls.codec.Sender;

public class FramedContent
implements MLSInputStream.Readable,
MLSOutputStream.Writable {
    byte[] group_id;
    long epoch;
    Sender sender;
    byte[] authenticated_data;
    byte[] application_data;
    final ContentType contentType;
    Proposal proposal;
    Commit commit;

    public Proposal getProposal() {
        return this.proposal;
    }

    public Commit getCommit() {
        return this.commit;
    }

    public Sender getSender() {
        return this.sender;
    }

    public byte[] getGroupID() {
        return this.group_id;
    }

    public long getEpoch() {
        return this.epoch;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public byte[] getAuthenticated_data() {
        return this.authenticated_data;
    }

    public byte[] getContentBytes() throws IOException {
        switch (this.contentType) {
            case APPLICATION: {
                return this.application_data;
            }
            case PROPOSAL: {
                return MLSOutputStream.encode(this.proposal);
            }
            case COMMIT: {
                return MLSOutputStream.encode(this.commit);
            }
        }
        return null;
    }

    public FramedContent(MLSInputStream stream) throws IOException {
        this.group_id = stream.readOpaque();
        this.epoch = (Long)stream.read(Long.TYPE);
        this.sender = (Sender)stream.read(Sender.class);
        this.authenticated_data = stream.readOpaque();
        this.contentType = ContentType.values()[(Byte)stream.read(Byte.TYPE)];
        switch (this.contentType) {
            case APPLICATION: {
                this.application_data = stream.readOpaque();
                break;
            }
            case PROPOSAL: {
                this.proposal = (Proposal)stream.read(Proposal.class);
                break;
            }
            case COMMIT: {
                this.commit = (Commit)stream.read(Commit.class);
            }
        }
    }

    public FramedContent(byte[] group_id, long epoch, Sender sender, byte[] authenticated_data, byte[] application_data, ContentType content_type, Proposal proposal, Commit commit) {
        this.group_id = group_id;
        this.epoch = epoch;
        this.sender = sender;
        this.authenticated_data = authenticated_data;
        this.application_data = application_data;
        this.contentType = content_type;
        this.proposal = proposal;
        this.commit = commit;
    }

    public static FramedContent rawContent(byte[] group_id, long epoch, Sender sender, byte[] authenticated_data, ContentType content_type, byte[] contentBytes) throws IOException {
        switch (content_type) {
            case APPLICATION: {
                return FramedContent.application(group_id, epoch, sender, authenticated_data, contentBytes);
            }
            case PROPOSAL: {
                return FramedContent.proposal(group_id, epoch, sender, authenticated_data, contentBytes);
            }
            case COMMIT: {
                return FramedContent.commit(group_id, epoch, sender, authenticated_data, contentBytes);
            }
        }
        return null;
    }

    public static FramedContent application(byte[] group_id, long epoch, Sender sender, byte[] authenticated_data, byte[] application_data) {
        return new FramedContent(group_id, epoch, sender, authenticated_data, application_data, ContentType.APPLICATION, null, null);
    }

    public static FramedContent proposal(byte[] group_id, long epoch, Sender sender, byte[] authenticated_data, byte[] proposal) throws IOException {
        return new FramedContent(group_id, epoch, sender, authenticated_data, null, ContentType.PROPOSAL, (Proposal)MLSInputStream.decode(proposal, Proposal.class), null);
    }

    public static FramedContent commit(byte[] group_id, long epoch, Sender sender, byte[] authenticated_data, byte[] commit) throws IOException {
        return new FramedContent(group_id, epoch, sender, authenticated_data, null, ContentType.COMMIT, null, (Commit)MLSInputStream.decode(commit, Commit.class));
    }

    @Override
    public void writeTo(MLSOutputStream stream) throws IOException {
        stream.writeOpaque(this.group_id);
        stream.write(this.epoch);
        stream.write(this.sender);
        stream.writeOpaque(this.authenticated_data);
        stream.write(this.contentType);
        switch (this.contentType) {
            case RESERVED: {
                break;
            }
            case APPLICATION: {
                stream.writeOpaque(this.application_data);
                break;
            }
            case PROPOSAL: {
                stream.write(this.proposal);
                break;
            }
            case COMMIT: {
                stream.write(this.commit);
            }
        }
    }
}

