/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mls.codec;

import java.io.IOException;
import org.bouncycastle.mls.codec.FramedContent;
import org.bouncycastle.mls.codec.MLSInputStream;
import org.bouncycastle.mls.codec.MLSOutputStream;
import org.bouncycastle.mls.codec.WireFormat;

class ConfirmedTranscriptHashInput
implements MLSInputStream.Readable,
MLSOutputStream.Writable {
    WireFormat wireFormat;
    FramedContent content;
    byte[] signature;

    public ConfirmedTranscriptHashInput(WireFormat wireFormat, FramedContent content, byte[] signature) {
        this.wireFormat = wireFormat;
        this.content = content;
        this.signature = signature;
    }

    public ConfirmedTranscriptHashInput(MLSInputStream stream) throws IOException {
        this.wireFormat = WireFormat.values()[(Short)stream.read(Short.TYPE)];
        this.content = (FramedContent)stream.read(FramedContent.class);
        this.signature = stream.readOpaque();
    }

    @Override
    public void writeTo(MLSOutputStream stream) throws IOException {
        stream.write(this.wireFormat);
        stream.write(this.content);
        stream.writeOpaque(this.signature);
    }
}

