/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mls.TreeKEM;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import org.bouncycastle.mls.TreeKEM.LeafIndex;
import org.bouncycastle.mls.TreeSize;

public class NodeIndex {
    private final long value;

    public long value() {
        return this.value;
    }

    public NodeIndex(long valueIn) {
        this.value = valueIn;
    }

    public NodeIndex(LeafIndex leaf) {
        this.value = 2 * leaf.value();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeIndex nodeIndex = (NodeIndex)o;
        return this.value == nodeIndex.value;
    }

    public static NodeIndex root(TreeSize size) {
        return new NodeIndex((1L << (int)size.depth()) - 1L);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public long level() {
        return Long.numberOfTrailingZeros(this.value ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public boolean isLeaf() {
        return this.value % 2L == 0L;
    }

    public boolean isBelow(NodeIndex other) {
        long ly;
        long lx = this.level();
        return lx <= (ly = other.level()) && this.value >> (int)(ly + 1L) == other.value >> (int)(ly + 1L);
    }

    public NodeIndex parent() {
        long k = this.level();
        return new NodeIndex((this.value | 1L << (int)k) & (1L << (int)(k + 1L) ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public NodeIndex left() {
        if (this.isLeaf()) {
            return this;
        }
        long k = this.level();
        return new NodeIndex(this.value ^ 1L << (int)(k - 1L));
    }

    public NodeIndex right() {
        if (this.isLeaf()) {
            return this;
        }
        long k = this.level();
        return new NodeIndex(this.value ^ 3L << (int)(k - 1L));
    }

    public NodeIndex sibling() {
        return this.sibling(this.parent());
    }

    public NodeIndex sibling(NodeIndex ancestor) {
        NodeIndex l = ancestor.left();
        NodeIndex r = ancestor.right();
        if (this.isBelow(l)) {
            return r;
        }
        return l;
    }

    public List<NodeIndex> copath(TreeSize size) throws Exception {
        List<NodeIndex> d = this.directPath(size);
        if (d.isEmpty()) {
            return new ArrayList<NodeIndex>();
        }
        d.add(0, this);
        d.remove(d.size() - 1);
        ArrayList<NodeIndex> cp = new ArrayList<NodeIndex>();
        for (NodeIndex n : d) {
            cp.add(n.sibling());
        }
        return cp;
    }

    private List<NodeIndex> directPath(TreeSize size) throws Exception {
        if (this.value >= size.width()) {
            throw new Exception("!!!Request for dirpath outside of tree!!!");
        }
        Vector<NodeIndex> d = new Vector<NodeIndex>();
        NodeIndex r = NodeIndex.root(size);
        if (this.equals(r)) {
            return d;
        }
        NodeIndex p = this.parent();
        while (!p.equals(r)) {
            d.add(p);
            p = p.parent();
        }
        if (!this.equals(r)) {
            d.add(p);
        }
        return d;
    }
}

