/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mls.TreeKEM;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bouncycastle.mls.TreeKEM.LeafIndex;
import org.bouncycastle.mls.TreeKEM.LeafNodeSource;
import org.bouncycastle.mls.TreeKEM.LifeTime;
import org.bouncycastle.mls.codec.Capabilities;
import org.bouncycastle.mls.codec.Credential;
import org.bouncycastle.mls.codec.CredentialType;
import org.bouncycastle.mls.codec.Extension;
import org.bouncycastle.mls.codec.MLSInputStream;
import org.bouncycastle.mls.codec.MLSOutputStream;
import org.bouncycastle.mls.crypto.MlsCipherSuite;
import org.bouncycastle.mls.protocol.Group;

public class LeafNode
implements MLSInputStream.Readable,
MLSOutputStream.Writable {
    MlsCipherSuite suite;
    byte[] encryption_key;
    byte[] signature_key;
    Credential credential;
    Capabilities capabilities;
    LeafNodeSource leaf_node_source;
    LifeTime lifeTime;
    byte[] parent_hash;
    List<Extension> extensions;
    byte[] signature;

    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    public CredentialType getCredentialType() {
        return this.credential.getCredentialType();
    }

    public MlsCipherSuite getSuite() {
        return this.suite;
    }

    public LifeTime getLifeTime() {
        return this.lifeTime;
    }

    public byte[] getEncryptionKey() {
        return this.encryption_key;
    }

    public byte[] getSignatureKey() {
        return this.signature_key;
    }

    public List<Extension> getExtensions() {
        return this.extensions;
    }

    public LeafNode(MlsCipherSuite suite, byte[] encryption_key, byte[] signature_key, Credential credential, Capabilities capabilities, LifeTime lifeTime, List<Extension> extensions, byte[] sigSk) throws Exception {
        this.suite = suite;
        this.encryption_key = encryption_key;
        this.signature_key = signature_key;
        this.credential = credential;
        this.capabilities = capabilities;
        this.lifeTime = lifeTime;
        this.extensions = new ArrayList<Extension>(extensions);
        this.leaf_node_source = LeafNodeSource.KEY_PACKAGE;
        this.sign(suite, sigSk, this.toBeSigned(null, -1));
    }

    public LeafNode() {
    }

    public LeafNode(MLSInputStream stream) throws IOException {
        this.encryption_key = stream.readOpaque();
        this.signature_key = stream.readOpaque();
        this.credential = (Credential)stream.read(Credential.class);
        this.capabilities = (Capabilities)stream.read(Capabilities.class);
        this.leaf_node_source = LeafNodeSource.values()[(Byte)stream.read(Byte.TYPE)];
        switch (this.leaf_node_source) {
            case KEY_PACKAGE: {
                this.lifeTime = (LifeTime)stream.read(LifeTime.class);
                break;
            }
            case UPDATE: {
                break;
            }
            case COMMIT: {
                this.parent_hash = stream.readOpaque();
            }
        }
        this.extensions = new ArrayList<Extension>();
        stream.readList(this.extensions, Extension.class);
        this.signature = stream.readOpaque();
    }

    @Override
    public void writeTo(MLSOutputStream stream) throws IOException {
        stream.writeOpaque(this.encryption_key);
        stream.writeOpaque(this.signature_key);
        stream.write(this.credential);
        stream.write(this.capabilities);
        stream.write(this.leaf_node_source);
        switch (this.leaf_node_source) {
            case KEY_PACKAGE: {
                stream.write(this.lifeTime);
                break;
            }
            case UPDATE: {
                break;
            }
            case COMMIT: {
                stream.writeOpaque(this.parent_hash);
            }
        }
        stream.writeList(this.extensions);
        stream.writeOpaque(this.signature);
    }

    public LeafNodeSource getSource() {
        return this.leaf_node_source;
    }

    public Credential getCredential() {
        return this.credential;
    }

    public byte[] toBeSigned(byte[] groupId, int leafIndex) throws IOException {
        MLSOutputStream stream = new MLSOutputStream();
        stream.writeOpaque(this.encryption_key);
        stream.writeOpaque(this.signature_key);
        stream.write(this.credential);
        stream.write(this.capabilities);
        stream.write(this.leaf_node_source);
        switch (this.leaf_node_source) {
            case KEY_PACKAGE: {
                stream.write(this.lifeTime);
                break;
            }
            case UPDATE: {
                break;
            }
            case COMMIT: {
                stream.writeOpaque(this.parent_hash);
            }
        }
        stream.writeList(this.extensions);
        switch (this.leaf_node_source) {
            case KEY_PACKAGE: {
                break;
            }
            case UPDATE: 
            case COMMIT: {
                stream.writeOpaque(groupId);
                stream.write(leafIndex);
            }
        }
        return stream.toByteArray();
    }

    public boolean verifyExtensionSupport(List<Extension> extensions) {
        return true;
    }

    public boolean verifyLifetime() {
        if (this.leaf_node_source != LeafNodeSource.KEY_PACKAGE) {
            return true;
        }
        return this.lifeTime.verify();
    }

    public boolean verify(MlsCipherSuite suite, byte[] tbs) throws IOException {
        if (this.getCredentialType() == CredentialType.x509) {
            // empty if block
        }
        return suite.verifyWithLabel(this.signature_key, "LeafNodeTBS", tbs, this.signature);
    }

    public LeafNode forCommit(MlsCipherSuite suite, byte[] groupId, LeafIndex leafIndex, byte[] encKeyIn, byte[] parentHash, Group.LeafNodeOptions options, byte[] sigPriv) throws Exception {
        LeafNode clone = this.copyWithOptions(encKeyIn, options);
        clone.leaf_node_source = LeafNodeSource.COMMIT;
        clone.parent_hash = (byte[])parentHash.clone();
        clone.sign(suite, sigPriv, clone.toBeSigned(groupId, leafIndex.value));
        return clone;
    }

    public LeafNode forUpdate(MlsCipherSuite suite, byte[] groupId, LeafIndex leafIndex, byte[] encKeyIn, Group.LeafNodeOptions options, byte[] sigPriv) throws Exception {
        LeafNode clone = this.copyWithOptions(encKeyIn, options);
        clone.leaf_node_source = LeafNodeSource.UPDATE;
        clone.sign(suite, sigPriv, clone.toBeSigned(groupId, leafIndex.value));
        return clone;
    }

    private void sign(MlsCipherSuite suite, byte[] sigPriv, byte[] tbs) throws Exception {
        byte[] sigPub = suite.serializeSignaturePublicKey(suite.deserializeSignaturePrivateKey(sigPriv).getPublic());
        if (!Arrays.equals(sigPub, this.signature_key)) {
            throw new Exception("Signature key mismatch");
        }
        this.signature = suite.signWithLabel(sigPriv, "LeafNodeTBS", tbs);
    }

    public LeafNode copyWithOptions(byte[] encKeyIn, Group.LeafNodeOptions options) {
        LeafNode clone = this.copy(encKeyIn);
        if (options.getCredential() != null) {
            clone.credential = options.getCredential();
        }
        if (options.getCapabilities() != null) {
            clone.capabilities = options.getCapabilities();
        }
        if (options.getExtensions() != null) {
            clone.extensions = options.getExtensions();
        }
        return clone;
    }

    public LeafNode copy(byte[] encKeyIn) {
        LeafNode clone = new LeafNode();
        clone.encryption_key = (byte[])encKeyIn.clone();
        clone.signature_key = (byte[])this.signature_key.clone();
        clone.credential = this.credential;
        clone.capabilities = this.capabilities;
        clone.leaf_node_source = this.leaf_node_source;
        switch (clone.leaf_node_source) {
            case KEY_PACKAGE: {
                clone.lifeTime = this.lifeTime;
                break;
            }
            case UPDATE: {
                break;
            }
            case COMMIT: {
                clone.parent_hash = (byte[])this.parent_hash.clone();
            }
        }
        clone.extensions = new ArrayList<Extension>(this.extensions);
        clone.signature = (byte[])this.signature.clone();
        return clone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LeafNode leafNode = (LeafNode)o;
        if (!Arrays.equals(this.encryption_key, leafNode.encryption_key)) {
            return false;
        }
        if (!Arrays.equals(this.signature_key, leafNode.signature_key)) {
            return false;
        }
        return Arrays.equals(this.signature, leafNode.signature);
    }
}

