/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime;

import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.cms.CMSAuthEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSAuthEnvelopedDataStreamGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.mail.smime.MailcapUtil;
import org.bouncycastle.mail.smime.SMIMEEnvelopedGenerator;
import org.bouncycastle.mail.smime.SMIMEException;
import org.bouncycastle.mail.smime.SMIMEStreamingProcessor;
import org.bouncycastle.operator.OutputAEADEncryptor;
import org.bouncycastle.operator.OutputEncryptor;

public class SMIMEAuthEnvelopedGenerator
extends SMIMEEnvelopedGenerator {
    public static final String AES128_GCM = CMSAuthEnvelopedDataGenerator.AES128_GCM;
    public static final String AES192_GCM = CMSAuthEnvelopedDataGenerator.AES192_GCM;
    public static final String AES256_GCM = CMSAuthEnvelopedDataGenerator.AES256_GCM;
    static final String AUTH_ENVELOPED_DATA_CONTENT_TYPE = "application/pkcs7-mime; name=\"smime.p7m\"; smime-type=authEnveloped-data";
    private final AuthEnvelopedGenerator authFact = new AuthEnvelopedGenerator();

    @Override
    public void addRecipientInfoGenerator(RecipientInfoGenerator recipientInfoGen) throws IllegalArgumentException {
        this.authFact.addRecipientInfoGenerator(recipientInfoGen);
    }

    @Override
    public void setBerEncodeRecipients(boolean berEncodeRecipientSet) {
        this.authFact.setBEREncodeRecipients(berEncodeRecipientSet);
    }

    @Override
    protected String getEncryptedContentType() {
        return AUTH_ENVELOPED_DATA_CONTENT_TYPE;
    }

    @Override
    protected SMIMEStreamingProcessor getContentEncryptor(MimeBodyPart content, OutputEncryptor encryptor) throws SMIMEException {
        if (encryptor instanceof OutputAEADEncryptor) {
            return new ContentEncryptor(content, (OutputAEADEncryptor)encryptor);
        }
        throw new SMIMEException("encryptor is not AEAD encryptor");
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                CommandMap commandMap = CommandMap.getDefaultCommandMap();
                if (commandMap instanceof MailcapCommandMap) {
                    CommandMap.setDefaultCommandMap((CommandMap)MailcapUtil.addCommands((MailcapCommandMap)commandMap));
                }
                return null;
            }
        });
    }

    private static class AuthEnvelopedGenerator
    extends CMSAuthEnvelopedDataStreamGenerator {
        private ASN1ObjectIdentifier dataType;
        private ASN1EncodableVector recipientInfos;

        private AuthEnvelopedGenerator() {
        }

        protected OutputStream open(ASN1ObjectIdentifier dataType, OutputStream out, ASN1EncodableVector recipientInfos, OutputAEADEncryptor encryptor) throws IOException {
            this.dataType = dataType;
            this.recipientInfos = recipientInfos;
            return super.open(dataType, out, recipientInfos, encryptor);
        }

        OutputStream regenerate(OutputStream out, OutputAEADEncryptor encryptor) throws IOException {
            return super.open(this.dataType, out, this.recipientInfos, encryptor);
        }
    }

    private class ContentEncryptor
    implements SMIMEStreamingProcessor {
        private final MimeBodyPart _content;
        private OutputAEADEncryptor _encryptor;
        private boolean _firstTime = true;

        ContentEncryptor(MimeBodyPart content, OutputAEADEncryptor encryptor) {
            this._content = content;
            this._encryptor = encryptor;
        }

        @Override
        public void write(OutputStream out) throws IOException {
            try {
                OutputStream encrypted;
                if (this._firstTime) {
                    encrypted = SMIMEAuthEnvelopedGenerator.this.authFact.open(out, this._encryptor);
                    this._firstTime = false;
                } else {
                    encrypted = SMIMEAuthEnvelopedGenerator.this.authFact.regenerate(out, this._encryptor);
                }
                CommandMap commandMap = CommandMap.getDefaultCommandMap();
                if (commandMap instanceof MailcapCommandMap) {
                    this._content.getDataHandler().setCommandMap((CommandMap)MailcapUtil.addCommands((MailcapCommandMap)commandMap));
                }
                this._content.writeTo(encrypted);
                encrypted.close();
            }
            catch (MessagingException e) {
                throw new SMIMEEnvelopedGenerator.WrappingIOException(e.toString(), e);
            }
            catch (CMSException e) {
                throw new SMIMEEnvelopedGenerator.WrappingIOException(e.toString(), e);
            }
        }
    }
}

