/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime.examples;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.smime.SMIMECapabilitiesAttribute;
import org.bouncycastle.asn1.smime.SMIMECapability;
import org.bouncycastle.asn1.smime.SMIMECapabilityVector;
import org.bouncycastle.asn1.smime.SMIMEEncryptionKeyPreferenceAttribute;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoGeneratorBuilder;
import org.bouncycastle.mail.smime.SMIMESignedGenerator;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.util.Store;

public class CreateSignedMultipartMail {
    static int serialNo = 1;

    static X509Certificate makeCertificate(KeyPair subKP, String subDN, KeyPair issKP, String issDN) throws GeneralSecurityException, IOException, OperatorCreationException {
        PublicKey subPub = subKP.getPublic();
        PrivateKey issPriv = issKP.getPrivate();
        PublicKey issPub = issKP.getPublic();
        JcaX509ExtensionUtils extUtils = new JcaX509ExtensionUtils();
        JcaX509v3CertificateBuilder v3CertGen = new JcaX509v3CertificateBuilder(new X500Name(issDN), BigInteger.valueOf(serialNo++), new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis() + 8640000000L), new X500Name(subDN), subPub);
        v3CertGen.addExtension(X509Extension.subjectKeyIdentifier, false, (ASN1Encodable)extUtils.createSubjectKeyIdentifier(subPub));
        v3CertGen.addExtension(X509Extension.authorityKeyIdentifier, false, (ASN1Encodable)extUtils.createAuthorityKeyIdentifier(issPub));
        return new JcaX509CertificateConverter().setProvider("BC").getCertificate(v3CertGen.build(new JcaContentSignerBuilder("MD5withRSA").setProvider("BC").build(issPriv)));
    }

    public static void main(String[] args) throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA", "BC");
        kpg.initialize(1024, new SecureRandom());
        String signDN = "O=Bouncy Castle, C=AU";
        KeyPair signKP = kpg.generateKeyPair();
        X509Certificate signCert = CreateSignedMultipartMail.makeCertificate(signKP, signDN, signKP, signDN);
        String origDN = "CN=Eric H. Echidna, E=eric@bouncycastle.org, O=Bouncy Castle, C=AU";
        KeyPair origKP = kpg.generateKeyPair();
        X509Certificate origCert = CreateSignedMultipartMail.makeCertificate(origKP, origDN, signKP, signDN);
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(origCert);
        certList.add(signCert);
        JcaCertStore certs = new JcaCertStore(certList);
        ASN1EncodableVector signedAttrs = new ASN1EncodableVector();
        SMIMECapabilityVector caps = new SMIMECapabilityVector();
        caps.addCapability(SMIMECapability.dES_EDE3_CBC);
        caps.addCapability(SMIMECapability.rC2_CBC, 128);
        caps.addCapability(SMIMECapability.dES_CBC);
        signedAttrs.add((ASN1Encodable)new SMIMECapabilitiesAttribute(caps));
        IssuerAndSerialNumber issAndSer = new IssuerAndSerialNumber(new X500Name(signDN), origCert.getSerialNumber());
        signedAttrs.add((ASN1Encodable)new SMIMEEncryptionKeyPreferenceAttribute(issAndSer));
        SMIMESignedGenerator gen = new SMIMESignedGenerator();
        gen.addSignerInfoGenerator(new JcaSimpleSignerInfoGeneratorBuilder().setProvider("BC").setSignedAttributeGenerator(new AttributeTable(signedAttrs)).build("SHA1withRSA", origKP.getPrivate(), origCert));
        gen.addCertificates((Store)certs);
        MimeBodyPart msg1 = new MimeBodyPart();
        msg1.setText("Hello part 1!");
        MimeBodyPart msg2 = new MimeBodyPart();
        msg2.setText("Hello part 2!");
        MimeMultipart mp = new MimeMultipart();
        mp.addBodyPart((BodyPart)msg1);
        mp.addBodyPart((BodyPart)msg2);
        MimeBodyPart m = new MimeBodyPart();
        m.setContent((Multipart)mp);
        MimeMultipart mm = gen.generate(m);
        Properties props = System.getProperties();
        Session session = Session.getDefaultInstance((Properties)props, null);
        InternetAddress fromUser = new InternetAddress("\"Eric H. Echidna\"<eric@bouncycastle.org>");
        InternetAddress toUser = new InternetAddress("example@bouncycastle.org");
        MimeMessage body = new MimeMessage(session);
        body.setFrom((Address)fromUser);
        body.setRecipient(Message.RecipientType.TO, (Address)toUser);
        body.setSubject("example signed message");
        body.setContent((Object)mm, mm.getContentType());
        body.saveChanges();
        body.writeTo((OutputStream)new FileOutputStream("signed.message"));
    }
}

