/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.spec;

import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.fips.FipsKDF;
import org.bouncycastle.jcajce.spec.PrfUtils;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class KTSKeySpec
implements KeySpec {
    public static final FipsKDF.AgreementKDFParametersBuilder KDF2 = FipsKDF.X963;
    public static final FipsKDF.AgreementKDFParametersBuilder KDF3 = FipsKDF.CONCATENATION;
    private final String keyAlgorithmName;
    private final int keySize;
    private final String macAlgorithm;
    private final int macKeySizeInBits;
    private final AlgorithmParameterSpec parameterSpec;
    private final AlgorithmIdentifier kdfAlgorithm;
    private final byte[] otherInfo;
    private final byte[] salt;

    KTSKeySpec(String keyAlgorithmName, int keySize, String macAlgorithm, int macKeySizeInBits, AlgorithmParameterSpec parameterSpec, AlgorithmIdentifier kdfAlgorithm, byte[] otherInfo, byte[] salt) {
        this.keyAlgorithmName = keyAlgorithmName;
        this.keySize = keySize;
        this.macAlgorithm = macAlgorithm;
        this.macKeySizeInBits = macKeySizeInBits;
        this.parameterSpec = parameterSpec;
        this.kdfAlgorithm = kdfAlgorithm;
        this.otherInfo = otherInfo;
        this.salt = salt;
    }

    public String getKeyAlgorithmName() {
        return this.keyAlgorithmName;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public String getMacAlgorithmName() {
        return this.macAlgorithm;
    }

    public int getMacKeySize() {
        return this.macKeySizeInBits;
    }

    public AlgorithmParameterSpec getParameterSpec() {
        return this.parameterSpec;
    }

    public AlgorithmIdentifier getKdfAlgorithmId() {
        return this.kdfAlgorithm;
    }

    public byte[] getOtherInfo() {
        return Arrays.clone(this.otherInfo);
    }

    public byte[] getKdfSalt() {
        return Arrays.clone(this.salt);
    }

    static AlgorithmIdentifier createAlgId(FipsKDF.AgreementKDFParametersBuilder kdfParamSource) {
        if (kdfParamSource.getAlgorithm().getName().startsWith(KDF2.getAlgorithm().getName())) {
            return new AlgorithmIdentifier(X9ObjectIdentifiers.id_kdf_kdf2, new AlgorithmIdentifier(PrfUtils.getObjectIdentifier(kdfParamSource.getPRF().getAlgorithm())));
        }
        if (kdfParamSource.getAlgorithm().getName().startsWith(KDF3.getAlgorithm().getName())) {
            return new AlgorithmIdentifier(X9ObjectIdentifiers.id_kdf_kdf3, new AlgorithmIdentifier(PrfUtils.getObjectIdentifier(kdfParamSource.getPRF().getAlgorithm())));
        }
        throw new IllegalArgumentException("kdfAlgorithm must be one of KDF2 or KDF3");
    }

    static byte[] copyOtherInfo(byte[] otherInfo) {
        return otherInfo == null ? new byte[]{} : Arrays.clone(otherInfo);
    }
}

