/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.spec.ECPoint;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.asymmetric.AsymmetricECGOST3410PublicKey;
import org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import org.bouncycastle.jcajce.interfaces.ECGOST3410PublicKey;
import org.bouncycastle.jcajce.provider.ECUtil;
import org.bouncycastle.jcajce.provider.GOST3410Util;
import org.bouncycastle.jcajce.provider.KeyUtil;
import org.bouncycastle.jcajce.provider.ProvKey;
import org.bouncycastle.jcajce.spec.ECDomainParameterSpec;
import org.bouncycastle.jcajce.spec.ECGOST3410PublicKeySpec;
import org.bouncycastle.jcajce.spec.GOST3410ParameterSpec;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvECGOST3410PublicKey
implements ECGOST3410PublicKey,
ProvKey<AsymmetricECGOST3410PublicKey> {
    private static final long serialVersionUID = 7026240464295649314L;
    private transient AsymmetricECGOST3410PublicKey baseKey;

    ProvECGOST3410PublicKey(Algorithm algorithm, ECGOST3410PublicKey key) {
        GOST3410ParameterSpec<ECDomainParameterSpec> params = key.getParams();
        this.baseKey = new AsymmetricECGOST3410PublicKey(algorithm, GOST3410Util.convertToECParams(params), ECUtil.convertPoint(params.getDomainParametersSpec(), key.getW()));
    }

    ProvECGOST3410PublicKey(Algorithm algorithm, ECGOST3410PublicKeySpec keySpec) {
        GOST3410ParameterSpec<ECDomainParameterSpec> params = keySpec.getParams();
        this.baseKey = new AsymmetricECGOST3410PublicKey(algorithm, GOST3410Util.convertToECParams(params), ECUtil.convertPoint(params.getDomainParametersSpec(), keySpec.getW()));
    }

    ProvECGOST3410PublicKey(AsymmetricECGOST3410PublicKey key) {
        this.baseKey = key;
    }

    @Override
    public AsymmetricECGOST3410PublicKey getBaseKey() {
        return this.baseKey;
    }

    @Override
    public String getAlgorithm() {
        return this.baseKey.getAlgorithm().getName();
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        return this.baseKey.getEncoded();
    }

    @Override
    public GOST3410ParameterSpec<ECDomainParameterSpec> getParams() {
        return GOST3410Util.convertToECSpec(this.baseKey.getParameters());
    }

    @Override
    public ECPoint getW() {
        return new ECPoint(this.baseKey.getW().getAffineXCoord().toBigInteger(), this.baseKey.getW().getAffineYCoord().toBigInteger());
    }

    public String toString() {
        return KeyUtil.publicKeyToString("ECGOST3410", this.baseKey.getW(), (ECDomainParameters)this.baseKey.getParameters().getDomainParameters());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProvECGOST3410PublicKey)) {
            return false;
        }
        ProvECGOST3410PublicKey other = (ProvECGOST3410PublicKey)o;
        return this.baseKey.equals(other.baseKey);
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Algorithm alg = (Algorithm)in.readObject();
        byte[] enc = (byte[])in.readObject();
        this.baseKey = new AsymmetricECGOST3410PublicKey(alg, enc);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.baseKey.getAlgorithm());
        out.writeObject(this.getEncoded());
    }
}

