/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.rosstandart.RosstandartObjectIdentifiers;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricKeyPairGenerator;
import org.bouncycastle.crypto.asymmetric.AsymmetricECGOST3410PrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricECGOST3410PublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricKeyPair;
import org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import org.bouncycastle.crypto.asymmetric.GOST3410Parameters;
import org.bouncycastle.crypto.general.ECGOST3410;
import org.bouncycastle.crypto.general.SecureHash;
import org.bouncycastle.jcajce.interfaces.ECGOST3410PrivateKey;
import org.bouncycastle.jcajce.interfaces.ECGOST3410PublicKey;
import org.bouncycastle.jcajce.provider.AsymmetricAlgorithmProvider;
import org.bouncycastle.jcajce.provider.BaseKeyFactory;
import org.bouncycastle.jcajce.provider.BaseSignature;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.GOST3410Util;
import org.bouncycastle.jcajce.provider.GuardedEngineCreator;
import org.bouncycastle.jcajce.provider.PrivateKeyConverter;
import org.bouncycastle.jcajce.provider.ProvECGOST3410PrivateKey;
import org.bouncycastle.jcajce.provider.ProvECGOST3410PublicKey;
import org.bouncycastle.jcajce.provider.PublicKeyConverter;
import org.bouncycastle.jcajce.provider.Utils;
import org.bouncycastle.jcajce.spec.ECDomainParameterSpec;
import org.bouncycastle.jcajce.spec.ECGOST3410PrivateKeySpec;
import org.bouncycastle.jcajce.spec.ECGOST3410PublicKeySpec;
import org.bouncycastle.jcajce.spec.GOST3410ParameterSpec;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvECGOST3410
extends AsymmetricAlgorithmProvider {
    private static final String PREFIX = "org.bouncycastle.jcajce.provider.asymmetric.ecgost.";
    private static final PublicKeyConverter<AsymmetricECGOST3410PublicKey> publicKeyConverter = new PublicKeyConverter<AsymmetricECGOST3410PublicKey>(){

        @Override
        public AsymmetricECGOST3410PublicKey convertKey(Algorithm algorithm, PublicKey key) throws InvalidKeyException {
            if (key instanceof ECGOST3410PublicKey) {
                if (key instanceof ProvECGOST3410PublicKey) {
                    return ((ProvECGOST3410PublicKey)key).getBaseKey();
                }
                return new ProvECGOST3410PublicKey(algorithm, (ECGOST3410PublicKey)key).getBaseKey();
            }
            try {
                return new AsymmetricECGOST3410PublicKey(algorithm, SubjectPublicKeyInfo.getInstance(Utils.getKeyEncoding(key)));
            }
            catch (Exception e) {
                throw new InvalidKeyException("Cannot identify ECGOST3410 public key: " + e.getMessage(), e);
            }
        }
    };
    private static final PrivateKeyConverter<AsymmetricECGOST3410PrivateKey> privateKeyConverter = new PrivateKeyConverter<AsymmetricECGOST3410PrivateKey>(){

        @Override
        public AsymmetricECGOST3410PrivateKey convertKey(Algorithm algorithm, PrivateKey key) throws InvalidKeyException {
            if (key instanceof ECGOST3410PrivateKey) {
                if (key instanceof ProvECGOST3410PrivateKey) {
                    return ((ProvECGOST3410PrivateKey)key).getBaseKey();
                }
                return new ProvECGOST3410PrivateKey(algorithm, (ECGOST3410PrivateKey)key).getBaseKey();
            }
            try {
                return new AsymmetricECGOST3410PrivateKey(algorithm, PrivateKeyInfo.getInstance(Utils.getKeyEncoding(key)));
            }
            catch (Exception e) {
                throw new InvalidKeyException("Cannot identify ECGOST3410 private key: " + e.getMessage(), e);
            }
        }
    };

    ProvECGOST3410() {
    }

    @Override
    public void configure(final BouncyCastleFipsProvider provider) {
        provider.addAlgorithmImplementation("KeyFactory.ECGOST3410", "org.bouncycastle.jcajce.provider.asymmetric.ecgost.KeyFactorySpi", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new KeyFactorySpi();
            }
        }));
        provider.addAlias("Alg.Alias.KeyFactory.GOST-3410-2001", "ECGOST3410");
        provider.addAlias("Alg.Alias.KeyFactory.ECGOST-3410", "ECGOST3410");
        provider.addAlgorithmImplementation("KeyPairGenerator.ECGOST3410", "org.bouncycastle.jcajce.provider.asymmetric.ecgost.KeyPairGeneratorSpi", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new KeyPairGenerator(provider);
            }
        }));
        provider.addAlias("Alg.Alias.KeyPairGenerator.ECGOST-3410", "ECGOST3410");
        provider.addAlias("Alg.Alias.KeyPairGenerator.GOST-3410-2001", "ECGOST3410");
        this.registerOid(provider, CryptoProObjectIdentifiers.gostR3410_2001, "ECGOST3410", new KeyFactorySpi());
        this.addSignatureAlgorithm(provider, "GOST3411", "ECGOST3410", "org.bouncycastle.jcajce.provider.asymmetric.ecgost.ECSignatureSpi", CryptoProObjectIdentifiers.gostR3411_94_with_gostR3410_2001, new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseSignature(provider, new ECGOST3410.SignatureOperatorFactory(), publicKeyConverter, privateKeyConverter, ECGOST3410.GOST3410);
            }
        }));
        provider.addAlias("Alg.Alias.Signature.ECGOST3410", "GOST3411WITHECGOST3410");
        provider.addAlias("Alg.Alias.Signature.ECGOST-3410", "GOST3411WITHECGOST3410");
        provider.addAlias("Alg.Alias.Signature.GOST-3410-2001", "GOST3411WITHECGOST3410");
        this.addSignatureAlgorithm(provider, "GOST3411-2012-256", "ECGOST3410", "org.bouncycastle.jcajce.provider.asymmetric.ecgost.EC256SignatureSpi", RosstandartObjectIdentifiers.id_tc26_signwithdigest_gost_3410_12_256, new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseSignature(provider, new ECGOST3410.SignatureOperatorFactory(), publicKeyConverter, privateKeyConverter, ECGOST3410.GOST3410.withDigestAlgorithm(SecureHash.Algorithm.GOST3411_2012_256));
            }
        }));
        provider.addAlias("Alg.Alias.Signature.ECGOST3410-2012-256", "GOST3411-2012-256WITHECGOST3410");
        provider.addAlias("Alg.Alias.Signature.ECGOST-3410-2012-256", "GOST3411-2012-256WITHECGOST3410");
        this.addSignatureAlgorithm(provider, "GOST3411-2012-512", "ECGOST3410", "org.bouncycastle.jcajce.provider.asymmetric.ecgost.EC512SignatureSpi", RosstandartObjectIdentifiers.id_tc26_signwithdigest_gost_3410_12_512, new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseSignature(provider, new ECGOST3410.SignatureOperatorFactory(), publicKeyConverter, privateKeyConverter, ECGOST3410.GOST3410.withDigestAlgorithm(SecureHash.Algorithm.GOST3411_2012_512));
            }
        }));
        provider.addAlias("Alg.Alias.Signature.ECGOST3410-2012-512", "GOST3411-2012-512WITHECGOST3410");
        provider.addAlias("Alg.Alias.Signature.ECGOST-3410-2012-512", "GOST3411-2012-512WITHECGOST3410");
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class KeyPairGenerator
    extends java.security.KeyPairGenerator {
        private final BouncyCastleFipsProvider fipsProvider;
        private GOST3410Parameters<ECDomainParameters> params;
        private AsymmetricKeyPairGenerator engine;
        private SecureRandom random;
        private boolean initialised = false;

        public KeyPairGenerator(BouncyCastleFipsProvider fipsProvider) {
            super("GOST3410");
            this.fipsProvider = fipsProvider;
            this.random = fipsProvider.getDefaultSecureRandom();
        }

        @Override
        public void initialize(int strength) {
            this.initialize(strength, this.fipsProvider.getDefaultSecureRandom());
        }

        @Override
        public void initialize(int strength, SecureRandom random) {
            throw new InvalidParameterException("ECGOST3410 KeyPairGenerator needs to be initialized with a GOST3410ParameterSpec");
        }

        private void init(GOST3410ParameterSpec gParams, SecureRandom random) {
            if (!(gParams.getDomainParametersSpec() instanceof ECDomainParameterSpec)) {
                throw new InvalidParameterException("GOST3410 KeyPairGenerator needs to be initialized with a GOST3410ParameterSpec<ECDomainParameterSpec>");
            }
            this.params = GOST3410Util.convertToECParams(gParams);
            this.engine = new ECGOST3410.KeyPairGenerator(new ECGOST3410.KeyGenParameters(this.params), random);
            this.initialised = true;
        }

        @Override
        public void initialize(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
            this.initialize(params, this.fipsProvider.getDefaultSecureRandom());
        }

        @Override
        public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            GOST3410ParameterSpec paramSpec;
            if (!(params instanceof GOST3410ParameterSpec) && !(params instanceof ECGenParameterSpec)) {
                throw new InvalidAlgorithmParameterException("AlgorithmParameterSpec not recognized: " + params.getClass().getName());
            }
            if (params instanceof ECGenParameterSpec) {
                ASN1ObjectIdentifier oid = ECGOST3410NamedCurves.getOID(((ECGenParameterSpec)params).getName());
                paramSpec = new GOST3410ParameterSpec(new GOST3410Parameters(oid));
            } else {
                paramSpec = (GOST3410ParameterSpec)params;
            }
            this.init(paramSpec, random);
        }

        @Override
        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                this.init(new GOST3410ParameterSpec(new GOST3410Parameters(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_A, CryptoProObjectIdentifiers.gostR3411)), this.random);
            }
            AsymmetricKeyPair pair = this.engine.generateKeyPair();
            AsymmetricECGOST3410PublicKey pub = (AsymmetricECGOST3410PublicKey)pair.getPublicKey();
            AsymmetricECGOST3410PrivateKey priv = (AsymmetricECGOST3410PrivateKey)pair.getPrivateKey();
            return new KeyPair(new ProvECGOST3410PublicKey(pub), new ProvECGOST3410PrivateKey(priv));
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class KeyFactorySpi
    extends BaseKeyFactory {
        @Override
        protected KeySpec engineGetKeySpec(Key key, Class spec) throws InvalidKeySpecException {
            ECGOST3410PrivateKey k;
            if (spec == null) {
                throw new InvalidKeySpecException("null spec is invalid");
            }
            if (spec.isAssignableFrom(ECGOST3410PublicKeySpec.class) && key instanceof ECGOST3410PublicKey) {
                ECGOST3410PublicKey k2 = (ECGOST3410PublicKey)key;
                if (k2.getParams() != null) {
                    return new ECGOST3410PublicKeySpec(k2.getW(), k2.getParams());
                }
            } else if (spec.isAssignableFrom(ECGOST3410PrivateKeySpec.class) && key instanceof ECGOST3410PrivateKey && (k = (ECGOST3410PrivateKey)key).getParams() != null) {
                return new ECGOST3410PrivateKeySpec(k.getS(), k.getParams());
            }
            return super.engineGetKeySpec(key, spec);
        }

        @Override
        protected Key engineTranslateKey(Key key) throws InvalidKeyException {
            if (key instanceof PublicKey) {
                return new ProvECGOST3410PublicKey((AsymmetricECGOST3410PublicKey)publicKeyConverter.convertKey(ECGOST3410.ALGORITHM, (PublicKey)key));
            }
            if (key instanceof PrivateKey) {
                return new ProvECGOST3410PrivateKey((AsymmetricECGOST3410PrivateKey)privateKeyConverter.convertKey(ECGOST3410.ALGORITHM, (PrivateKey)key));
            }
            if (key != null) {
                throw new InvalidKeyException("Key type unrecognized: " + key.getClass().getName());
            }
            throw new InvalidKeyException("Key is null");
        }

        @Override
        protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof ECGOST3410PrivateKeySpec) {
                return new ProvECGOST3410PrivateKey((Algorithm)ECGOST3410.ALGORITHM, (ECGOST3410PrivateKeySpec)keySpec);
            }
            return super.engineGeneratePrivate(keySpec);
        }

        @Override
        protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof ECGOST3410PublicKeySpec) {
                return new ProvECGOST3410PublicKey((Algorithm)ECGOST3410.ALGORITHM, (ECGOST3410PublicKeySpec)keySpec);
            }
            return super.engineGeneratePublic(keySpec);
        }

        @Override
        public PrivateKey generatePrivate(PrivateKeyInfo keyInfo) throws IOException {
            return new ProvECGOST3410PrivateKey(new AsymmetricECGOST3410PrivateKey((Algorithm)ECGOST3410.ALGORITHM, keyInfo));
        }

        @Override
        public PublicKey generatePublic(SubjectPublicKeyInfo keyInfo) throws IOException {
            return new ProvECGOST3410PublicKey(new AsymmetricECGOST3410PublicKey((Algorithm)ECGOST3410.ALGORITHM, keyInfo));
        }
    }
}

