/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.wrappers;

import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.crypto.internal.BlockCipher;
import org.bouncycastle.crypto.internal.DataLengthException;
import org.bouncycastle.crypto.internal.InvalidCipherTextException;
import org.bouncycastle.crypto.internal.wrappers.SP80038FWrapper;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class SP80038FWrapEngine
extends SP80038FWrapper {
    public SP80038FWrapEngine(BlockCipher engine, boolean useReverseDirection) {
        super(engine, ivKW, useReverseDirection);
    }

    @Override
    public String getAlgorithmName() {
        return this.engine.getAlgorithmName() + "/KW";
    }

    @Override
    public byte[] wrap(byte[] in, int inOff, int inLen) {
        if (!this.forWrapping) {
            throw new IllegalStateException("not set for wrapping");
        }
        int n = inLen / this.delta;
        if (n * this.delta != inLen) {
            throw new DataLengthException("wrap data must be a multiple of " + this.delta + " bytes");
        }
        byte[] block = new byte[inLen + this.iv.length];
        System.arraycopy(this.iv, 0, block, 0, this.iv.length);
        System.arraycopy(in, inOff, block, this.iv.length, inLen);
        if (n == 1) {
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                throw new FipsUnapprovedOperationError("wrap data must be at least " + 2 * this.delta + " bytes");
            }
            this.engine.init(this.wrapCipherMode, this.param);
            this.engine.processBlock(block, 0, block, 0);
            return block;
        }
        return this.W(n, block);
    }

    @Override
    public byte[] unwrap(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        if (this.forWrapping) {
            throw new IllegalStateException("not set for unwrapping");
        }
        int n = inLen / this.delta;
        if (n * this.delta != inLen) {
            throw new InvalidCipherTextException("unwrap data must be a multiple of " + this.delta + " bytes");
        }
        byte[] a = new byte[this.iv.length];
        byte[] block = new byte[inLen - this.iv.length];
        if (n == 2) {
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                throw new FipsUnapprovedOperationError("wrapped data must be at least " + 3 * this.delta + " bytes");
            }
            byte[] buf = new byte[2 * this.delta];
            System.arraycopy(in, 0, buf, 0, buf.length);
            this.engine.init(!this.wrapCipherMode, this.param);
            this.engine.processBlock(buf, 0, buf, 0);
            System.arraycopy(buf, 0, a, 0, this.iv.length);
            System.arraycopy(buf, this.iv.length, block, 0, inLen - this.iv.length);
        } else {
            System.arraycopy(in, inOff, a, 0, this.iv.length);
            System.arraycopy(in, inOff + this.iv.length, block, 0, inLen - this.iv.length);
            this.invW(n, block, a);
        }
        if (!Arrays.constantTimeAreEqual(a, this.iv)) {
            throw new InvalidCipherTextException("checksum failed");
        }
        return block;
    }
}

