/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.modes.gcm;

import java.util.Map;
import java.util.WeakHashMap;
import org.bouncycastle.crypto.internal.modes.gcm.GCMMultiplier;
import org.bouncycastle.crypto.internal.modes.gcm.Tables8kGCMMultiplier;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class GCMMultiplierCache {
    private static final Map<CacheKey, MultiplierProvider> values = new WeakHashMap<CacheKey, MultiplierProvider>();
    private static final CacheKey[] preserve = new CacheKey[8];
    private static int preserveCounter = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GCMMultiplier fetch(byte[] H) {
        MultiplierProvider m;
        byte[] h = Arrays.clone(H);
        CacheKey key = new CacheKey(h);
        Map<CacheKey, MultiplierProvider> map = values;
        synchronized (map) {
            m = values.get(key);
            if (m == null) {
                m = new MultiplierProvider(h);
                values.put(key, m);
                GCMMultiplierCache.preserve[GCMMultiplierCache.preserveCounter] = key;
                preserveCounter = (preserveCounter + 1) % preserve.length;
            }
        }
        return m.getMultiplier();
    }

    public synchronized int size() {
        return values.size();
    }

    public synchronized void clear() {
        values.clear();
        for (int i = 0; i != preserve.length; ++i) {
            GCMMultiplierCache.preserve[i] = null;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class CacheKey {
        private final byte[] H;
        private final int hashCode;

        CacheKey(byte[] H) {
            this.H = H;
            this.hashCode = Arrays.hashCode(H);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof CacheKey) {
                CacheKey other = (CacheKey)o;
                return Arrays.areEqual(other.H, this.H);
            }
            return false;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class MultiplierProvider {
        private final byte[] H;
        private GCMMultiplier m;

        MultiplierProvider(byte[] H) {
            this.H = H;
        }

        synchronized GCMMultiplier getMultiplier() {
            if (this.m == null) {
                this.m = new Tables8kGCMMultiplier();
                this.m.init(this.H);
            }
            return this.m;
        }
    }
}

