/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import org.bouncycastle.crypto.general.X448PrivateKeyParameters;
import org.bouncycastle.crypto.general.X448PublicKeyParameters;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.RawAgreement;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class X448Agreement
implements RawAgreement {
    private X448PrivateKeyParameters privateKey;

    X448Agreement() {
    }

    @Override
    public void init(CipherParameters parameters) {
        this.privateKey = (X448PrivateKeyParameters)parameters;
    }

    @Override
    public int getAgreementSize() {
        return 56;
    }

    @Override
    public void calculateAgreement(CipherParameters publicKey, byte[] buf, int off) {
        this.privateKey.generateSecret((X448PublicKeyParameters)publicKey, buf, off);
    }
}

