/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.security.SecureRandom;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AuthenticationParametersWithIV;
import org.bouncycastle.crypto.IllegalKeyException;
import org.bouncycastle.crypto.ParametersWithIV;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.SymmetricSecretKey;
import org.bouncycastle.crypto.general.CipherKeyGenerator;
import org.bouncycastle.crypto.general.CipherUtils;
import org.bouncycastle.crypto.general.DesEngine;
import org.bouncycastle.crypto.general.DesKeyGenerator;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.crypto.general.GeneralAuthParameters;
import org.bouncycastle.crypto.general.GeneralParameters;
import org.bouncycastle.crypto.general.GuardedAEADOperatorFactory;
import org.bouncycastle.crypto.general.GuardedMACOperatorFactory;
import org.bouncycastle.crypto.general.GuardedSymmetricKeyGenerator;
import org.bouncycastle.crypto.general.GuardedSymmetricOperatorFactory;
import org.bouncycastle.crypto.general.Mode;
import org.bouncycastle.crypto.general.Padding;
import org.bouncycastle.crypto.general.PrivilegedUtils;
import org.bouncycastle.crypto.general.SelfTestExecutor;
import org.bouncycastle.crypto.general.TripleDES;
import org.bouncycastle.crypto.general.Utils;
import org.bouncycastle.crypto.general.VariantKatTest;
import org.bouncycastle.crypto.internal.BlockCipher;
import org.bouncycastle.crypto.internal.BufferedBlockCipher;
import org.bouncycastle.crypto.internal.KeyGenerationParameters;
import org.bouncycastle.crypto.internal.Mac;
import org.bouncycastle.crypto.internal.ValidatedSymmetricKey;
import org.bouncycastle.crypto.internal.modes.AEADBlockCipher;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class DES {
    public static final GeneralAlgorithm ALGORITHM = new GeneralAlgorithm("DES");
    private static final EngineProvider ENGINE_PROVIDER;
    public static final Parameters ECB;
    public static final Parameters ECBwithPKCS7;
    public static final Parameters ECBwithISO10126_2;
    public static final Parameters ECBwithX923;
    public static final Parameters ECBwithISO7816_4;
    public static final Parameters ECBwithTBC;
    public static final Parameters CBC;
    public static final Parameters CBCwithPKCS7;
    public static final Parameters CBCwithISO10126_2;
    public static final Parameters CBCwithX923;
    public static final Parameters CBCwithISO7816_4;
    public static final Parameters CBCwithTBC;
    public static final Parameters CBCwithCS1;
    public static final Parameters CBCwithCS2;
    public static final Parameters CBCwithCS3;
    public static final Parameters CFB8;
    public static final Parameters CFB64;
    public static final Parameters OFB;
    public static final Parameters CTR;
    public static final AuthParameters EAX;
    public static final Parameters OpenPGPCFB;
    public static final AuthParameters CMAC;
    public static final AuthParameters CBC_MAC;
    public static final AuthParameters CBC_MACwithISO7816_4;
    public static final AuthParameters ISO9797alg3Mac;
    public static final AuthParameters ISO9797alg3MACwithISO7816_4;
    public static final AuthParameters CFB8_MAC;

    private DES() {
    }

    private static ValidatedSymmetricKey validateKey(SymmetricKey key, GeneralAlgorithm paramAlgorithm) {
        ValidatedSymmetricKey vKey = PrivilegedUtils.getValidatedKey(key);
        int keyLength = vKey.getKeySizeInBits();
        if (keyLength != 64) {
            if (paramAlgorithm.basicVariation() != Mode.ISO9797alg3) {
                throw new IllegalKeyException("DES key must be of length 64 bits including parity");
            }
            if (keyLength != 128 && keyLength != 192) {
                throw new IllegalKeyException("DES key for ISO979alg3 must be of length 128 or 192 bits including parity");
            }
        } else if (paramAlgorithm.basicVariation() == Mode.ISO9797alg3) {
            throw new IllegalKeyException("DES key for ISO979alg3 must be of length 128 or 192 bits including parity");
        }
        if (!vKey.getAlgorithm().equals(TripleDES.ALGORITHM)) {
            Utils.checkKeyAlgorithm(vKey, ALGORITHM, paramAlgorithm);
        }
        return vKey;
    }

    static {
        EngineProvider provider = new EngineProvider();
        provider.createEngine();
        ENGINE_PROVIDER = provider;
        ECB = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB));
        ECBwithPKCS7 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.PKCS7));
        ECBwithISO10126_2 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.ISO10126_2));
        ECBwithX923 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.X923));
        ECBwithISO7816_4 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.ISO7816_4));
        ECBwithTBC = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ECB, Padding.TBC));
        CBC = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC));
        CBCwithPKCS7 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.PKCS7));
        CBCwithISO10126_2 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.ISO10126_2));
        CBCwithX923 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.X923));
        CBCwithISO7816_4 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.ISO7816_4));
        CBCwithTBC = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.TBC));
        CBCwithCS1 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.CS1));
        CBCwithCS2 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.CS2));
        CBCwithCS3 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBC, Padding.CS3));
        CFB8 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CFB8));
        CFB64 = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CFB64));
        OFB = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.OFB64));
        CTR = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CTR));
        EAX = new AuthParameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.EAX));
        OpenPGPCFB = new Parameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.OpenPGPCFB));
        CMAC = new AuthParameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CMAC));
        CBC_MAC = new AuthParameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBCMAC));
        CBC_MACwithISO7816_4 = new AuthParameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CBCMAC, Padding.ISO7816_4));
        ISO9797alg3Mac = new AuthParameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ISO9797alg3));
        ISO9797alg3MACwithISO7816_4 = new AuthParameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.ISO9797alg3, Padding.ISO7816_4));
        CFB8_MAC = new AuthParameters(new GeneralAlgorithm(ALGORITHM, (Enum)Mode.CFB8MAC));
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class EngineProvider
    implements org.bouncycastle.crypto.internal.EngineProvider<BlockCipher> {
        private EngineProvider() {
        }

        @Override
        public BlockCipher createEngine() {
            return SelfTestExecutor.validate((Algorithm)ALGORITHM, new DesEngine(), new VariantKatTest<DesEngine>(){

                @Override
                public void evaluate(DesEngine engine) {
                    byte[] input = Hex.decode("00112233445566778899aabbccddeeff");
                    byte[] output = Hex.decode("e7109a793167d69a0e62538ba866f7f8");
                    byte[] tmp = new byte[input.length];
                    KeyParameterImpl key = new KeyParameterImpl(Hex.decode("1011121314151617"));
                    engine.init(true, key);
                    engine.processBlock(input, 0, tmp, 0);
                    engine.processBlock(input, 8, tmp, 8);
                    if (!Arrays.areEqual(output, tmp)) {
                        this.fail("Failed self test on encryption");
                    }
                    engine.init(false, key);
                    engine.processBlock(tmp, 0, tmp, 0);
                    engine.processBlock(tmp, 8, tmp, 8);
                    if (!Arrays.areEqual(input, tmp)) {
                        this.fail("Failed self test on decryption");
                    }
                }
            });
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class MACOperatorFactory
    extends GuardedMACOperatorFactory<AuthParameters> {
        @Override
        protected Mac createMAC(SymmetricKey key, AuthParameters parameters) {
            return CipherUtils.createStandardMac(DES.validateKey(key, (GeneralAlgorithm)parameters.getAlgorithm()), (org.bouncycastle.crypto.internal.EngineProvider<BlockCipher>)ENGINE_PROVIDER, (GeneralAuthParameters)parameters);
        }

        @Override
        protected int calculateMACSize(AuthParameters parameters) {
            return Utils.bitsToBytes(parameters.macLenInBits);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class AEADOperatorFactory
    extends GuardedAEADOperatorFactory<AuthParameters> {
        protected AEADBlockCipher createAEADCipher(boolean forEncryption, SymmetricKey key, AuthParameters parameters) {
            return CipherUtils.createStandardAEADCipher(forEncryption, DES.validateKey(key, (GeneralAlgorithm)parameters.getAlgorithm()), (org.bouncycastle.crypto.internal.EngineProvider<BlockCipher>)ENGINE_PROVIDER, (AuthenticationParametersWithIV)parameters);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class OperatorFactory
    extends GuardedSymmetricOperatorFactory<Parameters> {
        @Override
        protected BufferedBlockCipher createCipher(boolean forEncryption, SymmetricKey key, Parameters parameters, SecureRandom random) {
            return CipherUtils.createStandardCipher(forEncryption, DES.validateKey(key, (GeneralAlgorithm)parameters.getAlgorithm()), (org.bouncycastle.crypto.internal.EngineProvider<BlockCipher>)ENGINE_PROVIDER, (ParametersWithIV)parameters, random);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class KeyGenerator
    extends GuardedSymmetricKeyGenerator {
        private final GeneralAlgorithm algorithm;
        private final int keySizeInBits;
        private final SecureRandom random;

        public KeyGenerator(SecureRandom random) {
            this(ALGORITHM, 56, random);
        }

        public KeyGenerator(GeneralParameters algorithm, int keySizeInBits, SecureRandom random) {
            this((GeneralAlgorithm)algorithm.getAlgorithm(), keySizeInBits, random);
        }

        private KeyGenerator(GeneralAlgorithm algorithm, int keySizeInBits, SecureRandom random) {
            this.algorithm = algorithm;
            this.keySizeInBits = keySizeInBits;
            this.random = random;
        }

        @Override
        public SymmetricKey doGenerateKey() {
            DesKeyGenerator cipherKeyGenerator = new DesKeyGenerator();
            ((CipherKeyGenerator)cipherKeyGenerator).init(new KeyGenerationParameters(this.random, this.keySizeInBits));
            return new SymmetricSecretKey(this.algorithm, ((CipherKeyGenerator)cipherKeyGenerator).generateKey());
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class AuthParameters
    extends GeneralAuthParameters<AuthParameters> {
        private AuthParameters(GeneralAlgorithm algorithm, byte[] iv, int tagLenInBits) {
            super(algorithm, 8, iv, tagLenInBits);
        }

        AuthParameters(GeneralAlgorithm algorithm) {
            this(algorithm, null, Utils.getDefaultMacSize(algorithm, 64));
        }

        @Override
        protected AuthParameters create(GeneralAlgorithm algorithm, byte[] iv, int macSizeInBits) {
            return new AuthParameters(algorithm, iv, macSizeInBits);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class Parameters
    extends GeneralParameters<GeneralAlgorithm>
    implements ParametersWithIV {
        private final byte[] iv;

        Parameters(GeneralAlgorithm algorithm) {
            this(algorithm, null);
        }

        private Parameters(GeneralAlgorithm algorithm, byte[] iv) {
            super(algorithm);
            ((Mode)algorithm.basicVariation()).checkIv(iv, 8);
            this.iv = iv;
        }

        public Parameters withIV(byte[] iv) {
            return new Parameters((GeneralAlgorithm)this.getAlgorithm(), Arrays.clone(iv));
        }

        public Parameters withIV(SecureRandom random) {
            return new Parameters((GeneralAlgorithm)this.getAlgorithm(), ((GeneralAlgorithm)this.getAlgorithm()).createDefaultIvIfNecessary(8, random));
        }

        @Override
        public byte[] getIV() {
            return Arrays.clone(this.iv);
        }
    }
}

