/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import org.bouncycastle.crypto.EntropySource;
import org.bouncycastle.crypto.fips.ContinuousTestingEntropySource;
import org.bouncycastle.crypto.fips.DRBG;
import org.bouncycastle.crypto.fips.DRBGProvider;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.SelfTestExecutor;
import org.bouncycastle.crypto.fips.VariantInternalKatTest;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class DRBGPseudoRandom
implements DRBG {
    private final FipsAlgorithm algorithm;
    private final DRBGProvider drbgProvider;
    private final EntropySource entropySource;
    private DRBG drbg;
    private int reseedTestThreshold = 0;

    DRBGPseudoRandom(FipsAlgorithm algorithm, EntropySource entropySource, DRBGProvider drbgProvider) {
        this.algorithm = algorithm;
        this.entropySource = new ContinuousTestingEntropySource(entropySource);
        this.drbgProvider = drbgProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBlockSize() {
        DRBGPseudoRandom dRBGPseudoRandom = this;
        synchronized (dRBGPseudoRandom) {
            this.lazyInitDRBG();
            return this.drbg.getBlockSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSecurityStrength() {
        DRBGPseudoRandom dRBGPseudoRandom = this;
        synchronized (dRBGPseudoRandom) {
            this.lazyInitDRBG();
            return this.drbg.getSecurityStrength();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getPersonalizationString() {
        DRBGPseudoRandom dRBGPseudoRandom = this;
        synchronized (dRBGPseudoRandom) {
            this.lazyInitDRBG();
            return this.drbg.getPersonalizationString();
        }
    }

    private void lazyInitDRBG() {
        if (this.drbg == null) {
            this.drbg = this.drbgProvider.get(this.entropySource);
            SelfTestExecutor.validate(this.algorithm, this.drbg.createSelfTest(this.algorithm));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int generate(byte[] output, byte[] additionalInput, boolean predictionResistant) {
        DRBGPseudoRandom dRBGPseudoRandom = this;
        synchronized (dRBGPseudoRandom) {
            this.lazyInitDRBG();
            if (predictionResistant && this.triggerReseedTest()) {
                SelfTestExecutor.validate(this.algorithm, this.drbg.createReseedSelfTest(this.algorithm));
            }
            if (this.drbg.generate(output, additionalInput, predictionResistant) < 0) {
                if (this.triggerReseedTest()) {
                    SelfTestExecutor.validate(this.algorithm, this.drbg.createReseedSelfTest(this.algorithm));
                }
                this.drbg.reseed(null);
                return this.drbg.generate(output, additionalInput, predictionResistant);
            }
            return output.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reseed(byte[] additionalInput) {
        DRBGPseudoRandom dRBGPseudoRandom = this;
        synchronized (dRBGPseudoRandom) {
            this.lazyInitDRBG();
            if (this.triggerReseedTest()) {
                SelfTestExecutor.validate(this.algorithm, this.drbg.createReseedSelfTest(this.algorithm));
            }
            this.drbg.reseed(additionalInput);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VariantInternalKatTest createSelfTest(FipsAlgorithm algorithm) {
        DRBGPseudoRandom dRBGPseudoRandom = this;
        synchronized (dRBGPseudoRandom) {
            this.lazyInitDRBG();
            return this.drbg.createSelfTest(algorithm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VariantInternalKatTest createReseedSelfTest(FipsAlgorithm algorithm) {
        DRBGPseudoRandom dRBGPseudoRandom = this;
        synchronized (dRBGPseudoRandom) {
            this.lazyInitDRBG();
            return this.drbg.createReseedSelfTest(algorithm);
        }
    }

    private boolean triggerReseedTest() {
        if (this.reseedTestThreshold == 0 || (long)this.reseedTestThreshold > (System.currentTimeMillis() & 0x3FFL) + 50L) {
            this.reseedTestThreshold = 1;
            return true;
        }
        this.reseedTestThreshold = this.reseedTestThreshold + 1 & 0x3FF;
        return false;
    }
}

