/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import java.math.BigInteger;
import org.bouncycastle.crypto.asymmetric.DHValidationParameters;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DHDomainParameters {
    private static final int DEFAULT_MINIMUM_LENGTH = 160;
    private final BigInteger g;
    private final BigInteger p;
    private final BigInteger q;
    private final BigInteger j;
    private final int m;
    private final int l;
    private final DHValidationParameters validation;

    private static int getDefaultMParam(int lParam) {
        if (lParam == 0) {
            return 160;
        }
        return lParam < 160 ? lParam : 160;
    }

    public DHDomainParameters(BigInteger p, BigInteger g) {
        this(p, null, g, 0);
    }

    public DHDomainParameters(BigInteger p, BigInteger g, int l) {
        this(p, null, g, l);
    }

    public DHDomainParameters(BigInteger p, BigInteger q, BigInteger g) {
        this(p, q, g, 0);
    }

    public DHDomainParameters(BigInteger p, BigInteger q, BigInteger g, int l) {
        this(p, q, g, DHDomainParameters.getDefaultMParam(l), l, null, null);
    }

    public DHDomainParameters(BigInteger p, BigInteger q, BigInteger g, int m, int l) {
        this(p, q, g, m, l, null, null);
    }

    public DHDomainParameters(BigInteger p, BigInteger q, BigInteger g, BigInteger j, DHValidationParameters validation) {
        this(p, q, g, 160, 0, j, validation);
    }

    public DHDomainParameters(BigInteger p, BigInteger q, BigInteger g, int l, DHValidationParameters validation) {
        this(p, q, g, DHDomainParameters.getDefaultMParam(l), l, null, validation);
    }

    public DHDomainParameters(BigInteger p, BigInteger q, BigInteger g, int m, int l, BigInteger j, DHValidationParameters validation) {
        if (l != 0) {
            BigInteger bigL = BigInteger.valueOf(2L ^ (long)(l - 1));
            if (bigL.compareTo(p) == 1) {
                throw new IllegalArgumentException("when l value specified, it must satisfy 2^(l-1) <= p");
            }
            if (l < m) {
                throw new IllegalArgumentException("when l value specified, it may not be less than m value");
            }
        }
        this.g = g;
        this.p = p;
        this.q = q;
        this.m = m;
        this.l = l;
        this.j = j;
        this.validation = validation;
    }

    public BigInteger getP() {
        return this.p;
    }

    public BigInteger getG() {
        return this.g;
    }

    public BigInteger getQ() {
        return this.q;
    }

    public BigInteger getJ() {
        return this.j;
    }

    public int getM() {
        return this.m;
    }

    public int getL() {
        return this.l;
    }

    public DHValidationParameters getValidationParameters() {
        return this.validation;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DHDomainParameters)) {
            return false;
        }
        DHDomainParameters pm = (DHDomainParameters)obj;
        return pm.getP().equals(this.p) && pm.getG().equals(this.g);
    }

    public int hashCode() {
        return this.getP().hashCode() ^ this.getG().hashCode();
    }
}

