/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricKey;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.crypto.general.LMS;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class AsymmetricLMSKey
implements AsymmetricKey {
    private final boolean approvedModeOnly = CryptoServicesRegistrar.isInApprovedOnlyMode();
    private Algorithm algorithm = LMS.ALGORITHM;
    protected final int L;

    AsymmetricLMSKey(int L) {
        this.L = L;
    }

    @Override
    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public int getL() {
        return this.L;
    }

    protected void zeroize() {
        this.algorithm = null;
    }

    protected final boolean isThreadCorrectMode() {
        return this.approvedModeOnly == CryptoServicesRegistrar.isInApprovedOnlyMode();
    }

    protected final void checkApprovedOnlyModeStatus() {
        if (!this.isThreadCorrectMode()) {
            throw new FipsUnapprovedOperationError("No access to key in current thread.");
        }
    }
}

