/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.crypto.FinishedException;
import org.bouncycastle.crypto.UpdateException;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class UpdateOutputStream
extends OutputStream {
    public final void update(byte b) {
        try {
            this.write(b);
        }
        catch (IOException e) {
            if (e.getCause() != null) {
                throw new UpdateException(e.getClass().getName() + ": " + e.getMessage(), e.getCause());
            }
            throw new UpdateException("Exception processing data: " + e.getMessage(), e);
        }
    }

    public final void update(byte[] buffer) {
        this.update(buffer, 0, buffer.length);
    }

    public final void update(byte[] buffer, int off, int len) {
        try {
            this.write(buffer, off, len);
        }
        catch (IOException e) {
            if (e.getCause() != null) {
                throw new UpdateException(e.getClass().getName() + ": " + e.getMessage(), e.getCause());
            }
            throw new UpdateException("Exception processing data: " + e.getMessage(), e);
        }
    }

    public final void finished() {
        try {
            this.close();
        }
        catch (IOException e) {
            if (e.getCause() != null) {
                throw new FinishedException(e.getClass().getName() + ": " + e.getMessage(), e.getCause());
            }
            throw new FinishedException("Exception processing data: " + e.getMessage(), e);
        }
    }
}

