/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.spec;

import java.math.BigInteger;
import java.security.spec.DSAParameterSpec;
import org.bouncycastle.crypto.asymmetric.DSADomainParameters;
import org.bouncycastle.crypto.asymmetric.DSAValidationParameters;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DSADomainParameterSpec
extends DSAParameterSpec {
    private final DSAValidationParameters validationParameters;

    public DSADomainParameterSpec(DSADomainParameters domainParameters) {
        this(domainParameters.getP(), domainParameters.getQ(), domainParameters.getG(), domainParameters.getValidationParameters());
    }

    public DSADomainParameterSpec(BigInteger p, BigInteger q, BigInteger g) {
        this(p, q, g, null);
    }

    public DSADomainParameterSpec(BigInteger p, BigInteger q, BigInteger g, DSAValidationParameters validationParameters) {
        super(p, q, g);
        this.validationParameters = validationParameters;
    }

    public DSAValidationParameters getValidationParameters() {
        return this.validationParameters;
    }

    public DSADomainParameters getDomainParameters() {
        return new DSADomainParameters(this.getP(), this.getQ(), this.getG(), this.validationParameters);
    }
}

