/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEKeySpec;
import org.bouncycastle.crypto.PasswordBasedDeriver;
import org.bouncycastle.crypto.general.PBKD;
import org.bouncycastle.jcajce.provider.AlgorithmProvider;
import org.bouncycastle.jcajce.provider.BaseKDFSecretKeyFactory;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.GuardedEngineCreator;
import org.bouncycastle.jcajce.provider.PBKDFPBEKey;
import org.bouncycastle.util.Strings;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvOpenSSLPBKDF
extends AlgorithmProvider {
    private static final String PREFIX = ProvOpenSSLPBKDF.class.getName();

    ProvOpenSSLPBKDF() {
    }

    @Override
    void configure(BouncyCastleFipsProvider provider) {
        provider.addAlgorithmImplementation("SecretKeyFactory.PBKDF-OPENSSL", PREFIX + "$PBKDF", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new PBKDF();
            }
        }));
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class PBKDF
    extends BaseKDFSecretKeyFactory {
        PBKDF() {
        }

        @Override
        protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof PBEKeySpec) {
                PBEKeySpec pbeSpec = (PBEKeySpec)keySpec;
                if (pbeSpec.getSalt() == null) {
                    throw new InvalidKeySpecException("Missing required salt");
                }
                if (pbeSpec.getKeyLength() <= 0) {
                    throw new InvalidKeySpecException("Positive key length required: " + pbeSpec.getKeyLength());
                }
                PasswordBasedDeriver<PBKD.Parameters> deriver = new PBKD.DeriverFactory().createDeriver(PBKD.OpenSSL.using(Strings.toByteArray(pbeSpec.getPassword())).withSalt(pbeSpec.getSalt()));
                return new PBKDFPBEKey(deriver.deriveKey(PasswordBasedDeriver.KeyType.CIPHER, pbeSpec.getKeyLength() / 8), "PBKDF-OpenSSL", pbeSpec);
            }
            if (keySpec == null) {
                throw new InvalidKeySpecException("KeySpec cannot be null");
            }
            throw new InvalidKeySpecException("Invalid KeySpec: " + keySpec.getClass().getName());
        }
    }
}

