/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.jcajce.BCLoadStoreParameter;
import org.bouncycastle.jcajce.provider.AlgorithmProvider;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.GuardedEngineCreator;
import org.bouncycastle.jcajce.provider.ProvBCFKS;
import org.bouncycastle.jcajce.provider.ProvJKS;
import org.bouncycastle.jcajce.provider.Utils;
import org.bouncycastle.util.io.Streams;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvFipsKS
extends AlgorithmProvider {
    private static final String PREFIX = "org.bouncycastle.jcajce.provider.keystore.FipsKS.";

    ProvFipsKS() {
    }

    @Override
    void configure(final BouncyCastleFipsProvider provider) {
        provider.addAlgorithmImplementation("KeyStore.FIPS", "org.bouncycastle.jcajce.provider.keystore.FipsKS.FIPSKeyStore", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new FIPSKeyStore(false, provider);
            }
        });
        provider.addAlgorithmImplementation("KeyStore.IFIPS", "org.bouncycastle.jcajce.provider.keystore.FipsKS.IFIPSKeyStore", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new FIPSKeyStore(true, provider);
            }
        });
        if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            provider.addAlgorithmImplementation("KeyStore.FIPS-DEF", "org.bouncycastle.jcajce.provider.keystore.FipsKS.FIPSDefKeyStore", new GuardedEngineCreator(new EngineCreator(){

                @Override
                public Object createInstance(Object constructorParameter) {
                    return new FIPSKeyStore(false, null);
                }
            }));
            provider.addAlgorithmImplementation("KeyStore.IFIPS-DEF", "org.bouncycastle.jcajce.provider.keystore.FipsKS.IFIPDefSKeyStore", new GuardedEngineCreator(new EngineCreator(){

                @Override
                public Object createInstance(Object constructorParameter) {
                    return new FIPSKeyStore(true, null);
                }
            }));
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class FIPSKeyStore
    extends KeyStoreSpi {
        private final boolean isImmutable;
        private final BouncyCastleFipsProvider provider;
        private KeyStoreSpi keyStore;

        public FIPSKeyStore(boolean isImmutable, BouncyCastleFipsProvider provider) {
            this.isImmutable = isImmutable;
            this.provider = provider;
        }

        public Enumeration engineAliases() {
            return this.keyStore.engineAliases();
        }

        @Override
        public boolean engineContainsAlias(String alias) {
            return this.keyStore.engineContainsAlias(alias);
        }

        @Override
        public void engineDeleteEntry(String alias) throws KeyStoreException {
            if (this.isImmutable) {
                throw new KeyStoreException("delete operation not supported in immutable mode");
            }
            this.keyStore.engineDeleteEntry(alias);
        }

        @Override
        public Certificate engineGetCertificate(String alias) {
            return this.keyStore.engineGetCertificate(alias);
        }

        @Override
        public String engineGetCertificateAlias(Certificate cert) {
            return this.keyStore.engineGetCertificateAlias(cert);
        }

        @Override
        public Certificate[] engineGetCertificateChain(String alias) {
            return this.keyStore.engineGetCertificateChain(alias);
        }

        @Override
        public Date engineGetCreationDate(String alias) {
            return this.keyStore.engineGetCreationDate(alias);
        }

        @Override
        public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
            return this.keyStore.engineGetKey(alias, password);
        }

        @Override
        public boolean engineIsCertificateEntry(String alias) {
            return this.keyStore.engineIsCertificateEntry(alias);
        }

        @Override
        public boolean engineIsKeyEntry(String alias) {
            return this.keyStore.engineIsKeyEntry(alias);
        }

        @Override
        public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
            if (this.isImmutable) {
                throw new KeyStoreException("set operation not supported in immutable mode");
            }
            this.keyStore.engineSetCertificateEntry(alias, cert);
        }

        @Override
        public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
            if (this.isImmutable) {
                throw new KeyStoreException("set operation not supported in immutable mode");
            }
            this.keyStore.engineSetKeyEntry(alias, key, chain);
        }

        @Override
        public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
            if (this.isImmutable) {
                throw new KeyStoreException("set operation not supported in immutable mode");
            }
            this.keyStore.engineSetKeyEntry(alias, key, password, chain);
        }

        @Override
        public int engineSize() {
            return this.keyStore.engineSize();
        }

        @Override
        public void engineSetEntry(String alias, KeyStore.Entry entry, KeyStore.ProtectionParameter protParam) throws KeyStoreException {
            if (this.isImmutable) {
                throw new KeyStoreException("set operation not supported in immutable mode");
            }
            this.keyStore.engineSetEntry(alias, entry, protParam);
        }

        @Override
        public void engineLoad(KeyStore.LoadStoreParameter loadStoreParameter) throws IOException, NoSuchAlgorithmException, CertificateException {
            if (this.keyStore != null && this.isImmutable) {
                throw new IOException("immutable keystore already loaded");
            }
            if (loadStoreParameter == null) {
                this.engineLoad(null, null);
            } else if (loadStoreParameter instanceof BCLoadStoreParameter) {
                BCLoadStoreParameter bcParam = (BCLoadStoreParameter)loadStoreParameter;
                this.engineLoad(bcParam.getInputStream(), Utils.extractPassword(loadStoreParameter));
            } else {
                throw new IllegalArgumentException("no support for 'param' of type " + loadStoreParameter.getClass().getName());
            }
        }

        @Override
        public void engineLoad(InputStream stream, char[] password) throws IOException, CertificateException, NoSuchAlgorithmException {
            if (this.keyStore != null && this.isImmutable) {
                throw new IOException("immutable keystore already loaded");
            }
            if (stream == null) {
                if (this.isImmutable) {
                    this.keyStore = new ProvBCFKS.BCFIPSImmutableKeyStoreSpi(this.provider);
                    this.keyStore.engineLoad(null, password);
                } else {
                    this.keyStore = new ProvBCFKS.BCFIPSKeyStoreSpi(false, this.provider);
                    this.keyStore.engineLoad(null, password);
                }
                return;
            }
            byte[] ksData = Streams.readAll(stream);
            if (this.isImmutable) {
                try {
                    this.keyStore = new ProvBCFKS.BCFIPSImmutableKeyStoreSpi(this.provider);
                    this.keyStore.engineLoad((InputStream)new ByteArrayInputStream(ksData), password);
                }
                catch (Exception e) {
                    this.keyStore = new ProvJKS.JKSKeyStoreSpi(false, this.provider);
                    this.keyStore.engineLoad((InputStream)new ByteArrayInputStream(ksData), password);
                }
            } else {
                try {
                    this.keyStore = new ProvBCFKS.BCFIPSKeyStoreSpi(false, this.provider);
                    this.keyStore.engineLoad((InputStream)new ByteArrayInputStream(ksData), password);
                }
                catch (Exception e) {
                    this.keyStore = new ProvJKS.JKSKeyStoreSpi(false, this.provider);
                    this.keyStore.engineLoad((InputStream)new ByteArrayInputStream(ksData), password);
                }
            }
        }

        @Override
        public void engineStore(KeyStore.LoadStoreParameter param) throws IOException, NoSuchAlgorithmException, CertificateException {
            this.keyStore.engineStore(param);
        }

        @Override
        public void engineStore(OutputStream stream, char[] password) throws IOException, CertificateException, NoSuchAlgorithmException {
            this.keyStore.engineStore(stream, password);
        }
    }
}

