/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.asymmetric.AsymmetricECPublicKey;
import org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import org.bouncycastle.jcajce.provider.ECUtil;
import org.bouncycastle.jcajce.provider.KeyUtil;
import org.bouncycastle.jcajce.provider.ProvKey;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvECPublicKey
implements ECPublicKey,
ProvKey<AsymmetricECPublicKey> {
    private static final long serialVersionUID = -569596969144472700L;
    private transient AsymmetricECPublicKey baseKey;

    ProvECPublicKey(Algorithm algorithm, ECPublicKey key) {
        ECDomainParameters domainParameters = ECUtil.convertFromSpec(key.getParams());
        this.baseKey = new AsymmetricECPublicKey(algorithm, domainParameters, ECUtil.convertPoint(domainParameters.getCurve(), key.getW()));
    }

    ProvECPublicKey(Algorithm algorithm, ECPublicKeySpec keySpec) {
        ECDomainParameters domainParameters = ECUtil.convertFromSpec(keySpec.getParams());
        this.baseKey = new AsymmetricECPublicKey(algorithm, domainParameters, ECUtil.convertPoint(domainParameters.getCurve(), keySpec.getW()));
    }

    ProvECPublicKey(AsymmetricECPublicKey key) {
        this.baseKey = key;
    }

    @Override
    public AsymmetricECPublicKey getBaseKey() {
        return this.baseKey;
    }

    @Override
    public String getAlgorithm() {
        return "EC";
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        return this.baseKey.getEncoded();
    }

    @Override
    public ECParameterSpec getParams() {
        return ECUtil.convertToSpec(this.baseKey.getDomainParameters());
    }

    @Override
    public ECPoint getW() {
        return new ECPoint(this.baseKey.getW().getAffineXCoord().toBigInteger(), this.baseKey.getW().getAffineYCoord().toBigInteger());
    }

    public String toString() {
        return KeyUtil.publicKeyToString("EC", this.baseKey.getW(), this.baseKey.getDomainParameters());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ECPublicKey)) {
            return false;
        }
        if (o instanceof ProvECPublicKey) {
            ProvECPublicKey other = (ProvECPublicKey)o;
            return this.baseKey.equals(other.baseKey);
        }
        ECPublicKey other = (ECPublicKey)o;
        return Arrays.areEqual(this.getEncoded(), other.getEncoded());
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Algorithm alg = (Algorithm)in.readObject();
        byte[] enc = (byte[])in.readObject();
        this.baseKey = new AsymmetricECPublicKey(alg, enc);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.baseKey.getAlgorithm());
        out.writeObject(this.getEncoded());
    }
}

