/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.asn1.ntt.NTTObjectIdentifiers;
import org.bouncycastle.crypto.AuthenticationParametersWithIV;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.MACOperatorFactory;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.ParametersWithIV;
import org.bouncycastle.crypto.SymmetricKeyGenerator;
import org.bouncycastle.crypto.general.Camellia;
import org.bouncycastle.jcajce.provider.ASN1AlgorithmParameters;
import org.bouncycastle.jcajce.provider.AuthParametersCreator;
import org.bouncycastle.jcajce.provider.BaseCipher;
import org.bouncycastle.jcajce.provider.BaseKeyGenerator;
import org.bouncycastle.jcajce.provider.BaseMac;
import org.bouncycastle.jcajce.provider.BaseSecretKeyFactory;
import org.bouncycastle.jcajce.provider.BaseWrapCipher;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.GcmSpecUtil;
import org.bouncycastle.jcajce.provider.GuardedEngineCreator;
import org.bouncycastle.jcajce.provider.IVAlgorithmParameterGenerator;
import org.bouncycastle.jcajce.provider.IvParametersCreator;
import org.bouncycastle.jcajce.provider.KeyGeneratorCreator;
import org.bouncycastle.jcajce.provider.ParametersCreator;
import org.bouncycastle.jcajce.provider.ParametersCreatorProvider;
import org.bouncycastle.jcajce.provider.SymmetricAlgorithmProvider;
import org.bouncycastle.jcajce.provider.Utils;
import org.bouncycastle.jcajce.spec.WrapParameterSpec;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvCamellia
extends SymmetricAlgorithmProvider {
    private Camellia.OperatorFactory operatorFactory;
    private Camellia.AEADOperatorFactory aeadOperatorFactory;
    private Camellia.KeyWrapOperatorFactory keyWrapOperatorFactory;
    private static final String PREFIX = ProvCamellia.class.getName();
    private ParametersCreatorProvider<Parameters> generalParametersCreatorProvider = new ParametersCreatorProvider<Parameters>(){

        @Override
        public ParametersCreator get(final Parameters parameters) {
            if (Utils.isAuthMode(parameters.getAlgorithm())) {
                return new AuthParametersCreator((AuthenticationParametersWithIV)parameters);
            }
            if (parameters.getAlgorithm().equals(Camellia.KW.getAlgorithm()) || parameters.getAlgorithm().equals(Camellia.KWP.getAlgorithm())) {
                return new ParametersCreator(){

                    public Parameters createParameters(boolean forEncryption, AlgorithmParameterSpec spec, SecureRandom random) throws InvalidAlgorithmParameterException {
                        if (spec instanceof WrapParameterSpec) {
                            return ((Camellia.WrapParameters)parameters).withUsingInverseFunction(((WrapParameterSpec)spec).useInverseFunction());
                        }
                        return parameters;
                    }
                };
            }
            return new IvParametersCreator((ParametersWithIV)parameters);
        }
    };

    ProvCamellia() {
        if (!CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            this.aeadOperatorFactory = new Camellia.AEADOperatorFactory();
            this.keyWrapOperatorFactory = new Camellia.KeyWrapOperatorFactory();
            this.operatorFactory = new Camellia.OperatorFactory();
        }
    }

    private Camellia.OperatorFactory getGeneralOperatorFactory() {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            return null;
        }
        return this.operatorFactory;
    }

    @Override
    public void configure(final BouncyCastleFipsProvider provider) {
        final Class[] cipherSpecs = GcmSpecUtil.getCipherSpecClasses();
        final Class[] ivOnlySpec = new Class[]{IvParameterSpec.class};
        provider.addAlgorithmImplementation("AlgorithmParameters.CAMELLIA", PREFIX + "$AlgParams", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new ASN1AlgorithmParameters("Camellia");
            }
        }));
        provider.addAlias("AlgorithmParameters", "CAMELLIA", NTTObjectIdentifiers.id_camellia128_cbc, NTTObjectIdentifiers.id_camellia192_cbc, NTTObjectIdentifiers.id_camellia256_cbc);
        provider.addAlgorithmImplementation("AlgorithmParameterGenerator", NTTObjectIdentifiers.id_camellia128_cbc, PREFIX + "$AlgParamGen", (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new IVAlgorithmParameterGenerator(provider, "Camellia", 16);
            }
        }));
        provider.addAlias("AlgorithmParameterGenerator", NTTObjectIdentifiers.id_camellia128_cbc.getId(), NTTObjectIdentifiers.id_camellia192_cbc, NTTObjectIdentifiers.id_camellia256_cbc);
        provider.addAlgorithmImplementation("SecretKeyFactory.CAMELLIA", PREFIX + "$CAMELLIAKFACT", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseSecretKeyFactory("Camellia", Camellia.ALGORITHM, new BaseSecretKeyFactory.Validator(){

                    @Override
                    public byte[] validated(byte[] keyBytes) throws InvalidKeySpecException {
                        int size = keyBytes.length * 8;
                        if (size != 128 && size != 192 && size != 256) {
                            throw new InvalidKeySpecException("Provided key data wrong size for Camellia");
                        }
                        return keyBytes;
                    }
                });
            }
        }));
        GuardedEngineCreator camellia128Fact = new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return ProvCamellia.this.createFixedFactory(128);
            }
        });
        this.addSecretKeyFactoryForOIDs(provider, PREFIX + "SKF", camellia128Fact, NTTObjectIdentifiers.id_camellia128_cbc, NTTObjectIdentifiers.id_camellia128_wrap);
        GuardedEngineCreator camellia192Fact = new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return ProvCamellia.this.createFixedFactory(192);
            }
        });
        this.addSecretKeyFactoryForOIDs(provider, PREFIX + "SKF", camellia192Fact, NTTObjectIdentifiers.id_camellia192_cbc, NTTObjectIdentifiers.id_camellia192_wrap);
        GuardedEngineCreator camellia256Fact = new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return ProvCamellia.this.createFixedFactory(256);
            }
        });
        this.addSecretKeyFactoryForOIDs(provider, PREFIX + "SKF", camellia256Fact, NTTObjectIdentifiers.id_camellia256_cbc, NTTObjectIdentifiers.id_camellia256_wrap);
        provider.addAlgorithmImplementation("Cipher.CAMELLIA", PREFIX + "$ECB", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseCipher.Builder(provider, 128, Camellia.ECBwithPKCS7, Camellia.ECB, Camellia.ECBwithISO10126_2, Camellia.ECBwithISO7816_4, Camellia.ECBwithTBC, Camellia.ECBwithX923, Camellia.CBC, Camellia.CBCwithPKCS7, Camellia.CBCwithISO10126_2, Camellia.CBCwithISO7816_4, Camellia.CBCwithTBC, Camellia.CBCwithX923, Camellia.CBCwithCS1, Camellia.CBCwithCS2, Camellia.CBCwithCS3, Camellia.CFB128, Camellia.CFB8, Camellia.OpenPGPCFB, Camellia.OFB, Camellia.CTR, Camellia.GCM, Camellia.CCM, Camellia.OCB, Camellia.EAX).withGeneralOperators(ProvCamellia.this.generalParametersCreatorProvider, ProvCamellia.this.getGeneralOperatorFactory(), ProvCamellia.this.aeadOperatorFactory).withParameters(cipherSpecs).build();
            }
        }));
        provider.addAlgorithmImplementation("Cipher", NTTObjectIdentifiers.id_camellia128_cbc, PREFIX + "$CBC128", (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseCipher.Builder(provider, 128, Camellia.CBCwithPKCS7).withParameters(ivOnlySpec).withGeneralOperators(ProvCamellia.this.generalParametersCreatorProvider, ProvCamellia.this.operatorFactory, null).withFixedKeySize(128).build();
            }
        }));
        provider.addAlgorithmImplementation("Cipher", NTTObjectIdentifiers.id_camellia192_cbc, PREFIX + "$CBC192", (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseCipher.Builder(provider, 128, Camellia.CBCwithPKCS7).withParameters(ivOnlySpec).withGeneralOperators(ProvCamellia.this.generalParametersCreatorProvider, ProvCamellia.this.operatorFactory, null).withFixedKeySize(192).build();
            }
        }));
        provider.addAlgorithmImplementation("Cipher", NTTObjectIdentifiers.id_camellia256_cbc, PREFIX + "$CBC256", (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseCipher.Builder(provider, 128, Camellia.CBCwithPKCS7).withParameters(ivOnlySpec).withGeneralOperators(ProvCamellia.this.generalParametersCreatorProvider, ProvCamellia.this.operatorFactory, null).withFixedKeySize(256).build();
            }
        }));
        provider.addAlgorithmImplementation("Cipher.CAMELLIAKW", PREFIX + "$Wrap", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseWrapCipher.Builder(provider, Camellia.KW).withGeneralOperators(ProvCamellia.this.generalParametersCreatorProvider, ProvCamellia.this.keyWrapOperatorFactory).withParameters(ivOnlySpec).build();
            }
        }));
        provider.addAlgorithmImplementation("Cipher", NTTObjectIdentifiers.id_camellia128_wrap, PREFIX + "$Wrap128", (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) throws NoSuchAlgorithmException {
                return new BaseWrapCipher.Builder(provider, Camellia.KW).withFixedKeySize(128).withGeneralOperators(ProvCamellia.this.generalParametersCreatorProvider, ProvCamellia.this.keyWrapOperatorFactory).withParameters(ivOnlySpec).build();
            }
        }));
        provider.addAlgorithmImplementation("Cipher", NTTObjectIdentifiers.id_camellia192_wrap, PREFIX + "$Wrap192", (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) throws NoSuchAlgorithmException {
                return new BaseWrapCipher.Builder(provider, Camellia.KW).withFixedKeySize(192).withGeneralOperators(ProvCamellia.this.generalParametersCreatorProvider, ProvCamellia.this.keyWrapOperatorFactory).withParameters(ivOnlySpec).build();
            }
        }));
        provider.addAlgorithmImplementation("Cipher", NTTObjectIdentifiers.id_camellia256_wrap, PREFIX + "$Wrap256", (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) throws NoSuchAlgorithmException {
                return new BaseWrapCipher.Builder(provider, Camellia.KW).withFixedKeySize(256).withGeneralOperators(ProvCamellia.this.generalParametersCreatorProvider, ProvCamellia.this.keyWrapOperatorFactory).withParameters(ivOnlySpec).build();
            }
        }));
        provider.addAlias("Cipher", "CAMELLIAKW", "CAMELLIAWRAP");
        provider.addAlgorithmImplementation("Cipher.CAMELLIAKWP", PREFIX + "$WrapWithPad", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseWrapCipher.Builder(provider, Camellia.KWP).withGeneralOperators(ProvCamellia.this.generalParametersCreatorProvider, ProvCamellia.this.keyWrapOperatorFactory).withParameters(ivOnlySpec).build();
            }
        }));
        provider.addAlias("Cipher", "CAMELLIAKWP", "CAMELLIAWRAPPAD");
        provider.addAlgorithmImplementation("KeyGenerator.CAMELLIA", PREFIX + "$KeyGen", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseKeyGenerator(provider, "Camellia", 128, false, new KeyGeneratorCreator(){

                    @Override
                    public SymmetricKeyGenerator createInstance(int keySize, SecureRandom random) {
                        return new Camellia.KeyGenerator(keySize, random);
                    }
                });
            }
        }));
        GuardedEngineCreator camellia128Gen = new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseKeyGenerator(provider, "Camellia", 128, true, new KeyGeneratorCreator(){

                    @Override
                    public SymmetricKeyGenerator createInstance(int keySize, SecureRandom random) {
                        return new Camellia.KeyGenerator(128, random);
                    }
                });
            }
        });
        this.addKeyGeneratorForOIDs(provider, PREFIX, camellia128Gen, NTTObjectIdentifiers.id_camellia128_cbc, NTTObjectIdentifiers.id_camellia128_wrap);
        GuardedEngineCreator camellia192Gen = new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseKeyGenerator(provider, "Camellia", 192, true, new KeyGeneratorCreator(){

                    @Override
                    public SymmetricKeyGenerator createInstance(int keySize, SecureRandom random) {
                        return new Camellia.KeyGenerator(192, random);
                    }
                });
            }
        });
        this.addKeyGeneratorForOIDs(provider, PREFIX, camellia192Gen, NTTObjectIdentifiers.id_camellia192_cbc, NTTObjectIdentifiers.id_camellia192_wrap);
        GuardedEngineCreator camellia256Gen = new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseKeyGenerator(provider, "Camellia", 256, true, new KeyGeneratorCreator(){

                    @Override
                    public SymmetricKeyGenerator createInstance(int keySize, SecureRandom random) {
                        return new Camellia.KeyGenerator(256, random);
                    }
                });
            }
        });
        this.addKeyGeneratorForOIDs(provider, PREFIX, camellia256Gen, NTTObjectIdentifiers.id_camellia256_cbc, NTTObjectIdentifiers.id_camellia256_wrap);
        provider.addAlgorithmImplementation("Mac.CAMELLIAGMAC", PREFIX + "$GMAC", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseMac(Camellia.GMAC, (MACOperatorFactory)new Camellia.MACOperatorFactory(), new AuthParametersCreator(Camellia.GMAC));
            }
        }));
        provider.addAlias("Mac", "CAMELLIAGMAC", "CAMELLIA-GMAC");
        provider.addAlgorithmImplementation("Mac.CAMELLIACMAC", PREFIX + "$CMAC", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseMac(Camellia.CMAC, (MACOperatorFactory)new Camellia.MACOperatorFactory(), new AuthParametersCreator(Camellia.CMAC));
            }
        }));
        provider.addAlias("Mac", "CAMELLIACMAC", "CAMELLIA-CMAC");
        provider.addAlgorithmImplementation("Mac.CAMELLIACCMMAC", PREFIX + "$CAEMLLIACCMMAC", new GuardedEngineCreator(new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new BaseMac(Camellia.CCM, (MACOperatorFactory)new Camellia.MACOperatorFactory(), new AuthParametersCreator((AuthenticationParametersWithIV)Camellia.CCM.withMACSize(128)));
            }
        }));
        provider.addAlias("Mac", "CAMELLIACCMMAC", "CAMELLIA-CCMMAC");
    }

    private BaseSecretKeyFactory createFixedFactory(final int keySize) {
        return new BaseSecretKeyFactory("Camellia", Camellia.ALGORITHM, new BaseSecretKeyFactory.Validator(){

            @Override
            public byte[] validated(byte[] keyBytes) throws InvalidKeySpecException {
                int size = keyBytes.length * 8;
                if (size != keySize) {
                    throw new InvalidKeySpecException("Provided key data wrong size for Camellia-" + keySize);
                }
                return keyBytes;
            }
        });
    }
}

