/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.ByteArrayOutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.IllegalKeyException;
import org.bouncycastle.crypto.InvalidWrappingException;
import org.bouncycastle.crypto.KeyUnwrapper;
import org.bouncycastle.crypto.KeyWrapOperatorFactory;
import org.bouncycastle.crypto.KeyWrapper;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.ParametersWithIV;
import org.bouncycastle.crypto.PlainInputProcessingException;
import org.bouncycastle.crypto.SymmetricSecretKey;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsKeyWrapOperatorFactory;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.ParametersCreator;
import org.bouncycastle.jcajce.provider.ParametersCreatorProvider;
import org.bouncycastle.jcajce.provider.Utils;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class BaseWrapCipher
extends CipherSpi {
    private final BouncyCastleFipsProvider fipsProvider;
    private AlgorithmParameters engineParams = null;
    private final Map<Algorithm, Parameters> baseParametersMap;
    private Algorithm algorithm;
    private FipsKeyWrapOperatorFactory fipsKeyWrapOperatorFactory;
    private KeyWrapOperatorFactory generalKeyWrapOperatorFactory;
    private ParametersCreatorProvider fipsParametersProvider;
    private ParametersCreatorProvider generalParametersProvider;
    private Class[] availableSpecs;
    private int keySizeInBits;
    private Parameters wrapParameters;
    private KeyWrapper keyWrapper;
    private KeyUnwrapper keyUnwrapper;
    private ErasableOutputStream wrapStream = null;

    private BaseWrapCipher(BouncyCastleFipsProvider fipsProvider, Map<Algorithm, Parameters> baseParametersMap, Algorithm algorithm, FipsKeyWrapOperatorFactory fipsKeyWrapOperatorFactory, KeyWrapOperatorFactory generalKeyWrapOperatorFactory, Class[] availableSpecs, ParametersCreatorProvider fipsParametersProvider, ParametersCreatorProvider generalParametersProvider, int keySizeInBits) {
        this.fipsProvider = fipsProvider;
        this.baseParametersMap = baseParametersMap;
        this.algorithm = algorithm;
        this.fipsKeyWrapOperatorFactory = fipsKeyWrapOperatorFactory;
        this.generalKeyWrapOperatorFactory = generalKeyWrapOperatorFactory;
        this.availableSpecs = availableSpecs;
        this.fipsParametersProvider = fipsParametersProvider;
        this.generalParametersProvider = generalParametersProvider;
        this.keySizeInBits = keySizeInBits;
    }

    @Override
    protected int engineGetBlockSize() {
        return 0;
    }

    @Override
    protected byte[] engineGetIV() {
        if (this.wrapParameters instanceof ParametersWithIV) {
            return ((ParametersWithIV)this.wrapParameters).getIV();
        }
        return null;
    }

    @Override
    protected int engineGetKeySize(Key key) {
        return key.getEncoded().length * 8;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        return -1;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        ParametersWithIV ivParams;
        if (this.wrapParameters instanceof ParametersWithIV && (ivParams = (ParametersWithIV)this.wrapParameters).getIV() != null) {
            String name = Utils.getBaseName(this.wrapParameters.getAlgorithm());
            try {
                this.engineParams = AlgorithmParameters.getInstance(name, this.fipsProvider);
                this.engineParams.init(new DEROctetString(ivParams.getIV()).getEncoded());
                return this.engineParams;
            }
            catch (Exception e) {
                throw new IllegalStateException(e.toString(), e);
            }
        }
        return null;
    }

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        throw new NoSuchAlgorithmException("Cannot support mode " + mode);
    }

    @Override
    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        throw new NoSuchPaddingException("Padding " + padding + " unknown");
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        ParametersCreator parametersCreator = this.algorithm instanceof FipsAlgorithm ? this.fipsParametersProvider.get(this.baseParametersMap.get(this.algorithm)) : this.generalParametersProvider.get(this.baseParametersMap.get(this.algorithm));
        SymmetricSecretKey symmetricKey = new SymmetricSecretKey(this.algorithm, key.getEncoded());
        if (this.keySizeInBits != 0 && Utils.keyNotLength(symmetricKey, this.keySizeInBits)) {
            throw new InvalidKeyException("Cipher requires key of size " + this.keySizeInBits + " bits");
        }
        if (random == null) {
            random = this.fipsProvider.getDefaultSecureRandom();
        }
        this.wrapStream = null;
        try {
            switch (opmode) {
                case 1: {
                    this.wrapStream = new ErasableOutputStream();
                }
                case 3: {
                    this.wrapParameters = parametersCreator.createParameters(true, params, random);
                    this.keyWrapper = this.algorithm instanceof FipsAlgorithm ? this.fipsKeyWrapOperatorFactory.createKeyWrapper(symmetricKey, this.wrapParameters) : this.generalKeyWrapOperatorFactory.createKeyWrapper(symmetricKey, this.wrapParameters);
                    this.keyWrapper = Utils.addRandomIfNeeded(this.keyWrapper, random);
                    this.keyUnwrapper = null;
                    break;
                }
                case 2: {
                    this.wrapStream = new ErasableOutputStream();
                }
                case 4: {
                    this.wrapParameters = parametersCreator.createParameters(false, params, random);
                    this.keyUnwrapper = this.algorithm instanceof FipsAlgorithm ? this.fipsKeyWrapOperatorFactory.createKeyUnwrapper(symmetricKey, this.wrapParameters) : this.generalKeyWrapOperatorFactory.createKeyUnwrapper(symmetricKey, this.wrapParameters);
                    this.keyUnwrapper = Utils.addRandomIfNeeded(this.keyUnwrapper, random);
                    this.keyWrapper = null;
                    break;
                }
                default: {
                    throw new InvalidParameterException("Unknown mode parameter passed to init.");
                }
            }
        }
        catch (InvalidParameterException e) {
            throw e;
        }
        catch (IllegalKeyException e) {
            throw new InvalidKeyException(e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidAlgorithmParameterException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new InvalidKeyException(e.getMessage(), e);
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec paramSpec = null;
        if (params != null) {
            for (int i = 0; i != this.availableSpecs.length; ++i) {
                try {
                    paramSpec = (AlgorithmParameterSpec)params.getParameterSpec(this.availableSpecs[i]);
                    break;
                }
                catch (Exception exception) {
                    continue;
                }
            }
            if (paramSpec == null) {
                throw new InvalidAlgorithmParameterException("can't handle parameter " + params.toString());
            }
        }
        this.engineParams = params;
        this.engineInit(opmode, key, paramSpec, random);
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidKeyException(e.getMessage(), e);
        }
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        if (this.wrapStream == null) {
            throw new IllegalStateException("not supported in a wrapping mode");
        }
        this.wrapStream.write(input, inputOffset, inputLen);
        return null;
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        if (this.wrapStream == null) {
            throw new IllegalStateException("not supported in a wrapping mode");
        }
        this.wrapStream.write(input, inputOffset, inputLen);
        return 0;
    }

    /*
     * Loose catch block
     */
    @Override
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        if (this.wrapStream == null) {
            throw new IllegalStateException("not supported in a wrapping mode");
        }
        if (input != null) {
            this.wrapStream.write(input, inputOffset, inputLen);
        }
        if (this.keyWrapper != null) {
            try {
                byte[] byArray = this.keyWrapper.wrap(this.wrapStream.getBuf(), 0, this.wrapStream.size());
                return byArray;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalBlockSizeException(e.getMessage());
            }
            catch (PlainInputProcessingException e) {
                throw new BadPaddingException(e.getMessage());
            }
        }
        byte[] e = this.keyUnwrapper.unwrap(this.wrapStream.getBuf(), 0, this.wrapStream.size());
        return e;
        catch (InvalidWrappingException e2) {
            throw new BadPaddingException(e2.getMessage());
        }
        finally {
            this.wrapStream.erase();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalBlockSizeException, BadPaddingException, ShortBufferException {
        if (this.wrapStream == null) {
            throw new IllegalStateException("not supported in a wrapping mode");
        }
        this.wrapStream.write(input, inputOffset, inputLen);
        try {
            byte[] enc;
            if (this.keyWrapper != null) {
                try {
                    enc = this.keyWrapper.wrap(this.wrapStream.getBuf(), 0, this.wrapStream.size());
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalBlockSizeException(e.getMessage());
                }
                catch (PlainInputProcessingException e) {
                    throw new BadPaddingException(e.getMessage());
                }
            }
            try {
                enc = this.keyUnwrapper.unwrap(this.wrapStream.getBuf(), 0, this.wrapStream.size());
            }
            catch (InvalidWrappingException e) {
                throw new BadPaddingException(e.getMessage());
            }
            if (outputOffset + enc.length > output.length) {
                throw new ShortBufferException("output buffer too short for input.");
            }
            System.arraycopy(enc, 0, output, outputOffset, enc.length);
            int n = enc.length;
            return n;
        }
        finally {
            this.wrapStream.erase();
        }
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        byte[] encoded = key.getEncoded();
        if (encoded == null) {
            throw new InvalidKeyException("Cannot wrap key, null encoding.");
        }
        try {
            return this.keyWrapper.wrap(encoded, 0, encoded.length);
        }
        catch (PlainInputProcessingException e) {
            throw new IllegalBlockSizeException(e.getMessage());
        }
    }

    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] encoded;
        try {
            encoded = this.keyUnwrapper.unwrap(wrappedKey, 0, wrappedKey.length);
        }
        catch (Exception e) {
            throw new InvalidKeyException(e.getMessage(), e.getCause());
        }
        return BaseWrapCipher.rebuildKey(wrappedKeyAlgorithm, wrappedKeyType, encoded, this.fipsProvider);
    }

    static Key rebuildKey(String wrappedKeyAlgorithm, int wrappedKeyType, byte[] encoded, BouncyCastleFipsProvider fipsProvider) throws InvalidKeyException, NoSuchAlgorithmException {
        if (wrappedKeyType == 3) {
            return new SecretKeySpec(encoded, wrappedKeyAlgorithm);
        }
        if (wrappedKeyType == 2) {
            try {
                if (wrappedKeyAlgorithm == null || wrappedKeyAlgorithm.equals("")) {
                    PrivateKeyInfo in = PrivateKeyInfo.getInstance(encoded);
                    PrivateKey privKey = fipsProvider.getPrivateKey(in);
                    if (privKey != null) {
                        return privKey;
                    }
                    throw new InvalidKeyException("Algorithm " + in.getPrivateKeyAlgorithm().getAlgorithm() + " not supported");
                }
                KeyFactory kf = KeyFactory.getInstance(wrappedKeyAlgorithm, fipsProvider);
                return kf.generatePrivate(new PKCS8EncodedKeySpec(encoded));
            }
            catch (Exception e) {
                throw new InvalidKeyException("Invalid private key encoding: " + e.getMessage(), e);
            }
        }
        try {
            if (wrappedKeyAlgorithm == null || wrappedKeyAlgorithm.equals("")) {
                SubjectPublicKeyInfo in = SubjectPublicKeyInfo.getInstance(encoded);
                PublicKey pubKey = fipsProvider.getPublicKey(in);
                if (pubKey != null) {
                    return pubKey;
                }
                throw new InvalidKeyException("Algorithm " + in.getAlgorithm().getAlgorithm() + " not supported");
            }
            KeyFactory kf = KeyFactory.getInstance(wrappedKeyAlgorithm, fipsProvider);
            return kf.generatePublic(new X509EncodedKeySpec(encoded));
        }
        catch (Exception e) {
            throw new InvalidKeyException("Invalid private key encoding: " + e.getMessage(), e);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    protected static final class ErasableOutputStream
    extends ByteArrayOutputStream {
        public byte[] getBuf() {
            return this.buf;
        }

        public void erase() {
            Arrays.fill(this.buf, (byte)0);
            this.reset();
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class Builder {
        private final BouncyCastleFipsProvider fipsProvider;
        private final Algorithm[] algorithms;
        private final Map<Algorithm, Parameters> baseParametersMap;
        private FipsKeyWrapOperatorFactory fipsFactory;
        private KeyWrapOperatorFactory generalFactory;
        private Class[] availableSpecs;
        private int keySizeInBits;
        private ParametersCreatorProvider fipsParametersProvider;
        private ParametersCreatorProvider generalParametersProvider;

        Builder(BouncyCastleFipsProvider fipsProvider, Algorithm ... algorithms) {
            this.fipsProvider = fipsProvider;
            this.algorithms = algorithms;
            this.baseParametersMap = null;
        }

        Builder(BouncyCastleFipsProvider fipsProvider, Parameters ... parameters) {
            this.fipsProvider = fipsProvider;
            this.baseParametersMap = new HashMap<Algorithm, Parameters>(parameters.length);
            this.algorithms = new Algorithm[parameters.length];
            for (int i = 0; i != parameters.length; ++i) {
                this.baseParametersMap.put(parameters[i].getAlgorithm(), parameters[i]);
                this.algorithms[i] = parameters[i].getAlgorithm();
            }
        }

        Builder withFixedKeySize(int keySizeInBits) {
            this.keySizeInBits = keySizeInBits;
            return this;
        }

        Builder withFipsOperators(ParametersCreatorProvider fipsParametersProvider, FipsKeyWrapOperatorFactory fipsFactory) {
            this.fipsParametersProvider = fipsParametersProvider;
            this.fipsFactory = fipsFactory;
            return this;
        }

        Builder withGeneralOperators(ParametersCreatorProvider generalParametersProvider, KeyWrapOperatorFactory generalFactory) {
            this.generalParametersProvider = generalParametersProvider;
            this.generalFactory = generalFactory;
            return this;
        }

        Builder withParameters(Class[] availableSpecs) {
            this.availableSpecs = availableSpecs;
            return this;
        }

        BaseWrapCipher build() {
            boolean isInApprovedMode = CryptoServicesRegistrar.isInApprovedOnlyMode();
            if (!isInApprovedMode) {
                return new BaseWrapCipher(this.fipsProvider, this.baseParametersMap, this.algorithms[0], this.fipsFactory, this.generalFactory, this.availableSpecs, this.fipsParametersProvider, this.generalParametersProvider, this.keySizeInBits);
            }
            Set<Algorithm> activeSet = Utils.getActiveSet(this.algorithms);
            if (activeSet.isEmpty()) {
                return null;
            }
            return new BaseWrapCipher(this.fipsProvider, this.baseParametersMap, activeSet.toArray(new Algorithm[activeSet.size()])[0], this.fipsFactory, this.generalFactory, this.availableSpecs, this.fipsParametersProvider, this.generalParametersProvider, this.keySizeInBits);
        }
    }
}

