/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.pqc.lms;

import java.io.ByteArrayOutputStream;
import org.bouncycastle.util.Encodable;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Composer {
    private final ByteArrayOutputStream bos = new ByteArrayOutputStream();

    private Composer() {
    }

    public static Composer compose() {
        return new Composer();
    }

    public Composer u64str(long n) {
        this.u32str((int)(n >>> 32));
        this.u32str((int)n);
        return this;
    }

    public Composer u32str(int n) {
        this.bos.write((byte)(n >>> 24));
        this.bos.write((byte)(n >>> 16));
        this.bos.write((byte)(n >>> 8));
        this.bos.write((byte)n);
        return this;
    }

    public Composer u16str(int n) {
        this.bos.write((byte)((n &= 0xFFFF) >>> 8));
        this.bos.write((byte)n);
        return this;
    }

    public Composer bytes(Encodable[] encodable) {
        try {
            for (Encodable e : encodable) {
                this.bos.write(e.getEncoded());
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        return this;
    }

    public Composer bytes(Encodable encodable) {
        try {
            this.bos.write(encodable.getEncoded());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        return this;
    }

    public Composer pad(int v, int len) {
        while (len >= 0) {
            try {
                this.bos.write(v);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
            --len;
        }
        return this;
    }

    public Composer bytes(byte[][] arrays) {
        try {
            for (byte[] array : arrays) {
                this.bos.write(array);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        return this;
    }

    public Composer bytes(byte[][] arrays, int start, int end) {
        try {
            for (int j = start; j != end; ++j) {
                this.bos.write(arrays[j]);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        return this;
    }

    public Composer bytes(byte[] array) {
        try {
            this.bos.write(array);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        return this;
    }

    public Composer bytes(byte[] array, int start, int len) {
        try {
            this.bos.write(array, start, len);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        return this;
    }

    public byte[] build() {
        return this.bos.toByteArray();
    }

    public Composer padUntil(int v, int requiredLen) {
        while (this.bos.size() < requiredLen) {
            this.bos.write(v);
        }
        return this;
    }

    public Composer bool(boolean v) {
        this.bos.write(v ? 1 : 0);
        return this;
    }
}

