/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.io;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.crypto.CipherOutputStream;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.StreamException;
import org.bouncycastle.crypto.internal.BufferedBlockCipher;
import org.bouncycastle.crypto.internal.InvalidCipherTextException;
import org.bouncycastle.crypto.internal.StreamCipher;
import org.bouncycastle.crypto.internal.io.StreamIOException;
import org.bouncycastle.crypto.internal.io.Utils;
import org.bouncycastle.crypto.internal.modes.AEADCipher;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.WrappedByteArrayOutputStream;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class CipherOutputStreamImpl
extends CipherOutputStream {
    protected final String algorithmName;
    protected final boolean isApprovedMode;
    protected OutputStream out;
    protected final byte[] oneByte = new byte[1];
    private static final int INPUT_LEN = 32768;

    protected CipherOutputStreamImpl(String algorithmName, OutputStream out) {
        this.algorithmName = algorithmName;
        this.isApprovedMode = CryptoServicesRegistrar.isInApprovedOnlyMode();
        this.out = out;
    }

    @Override
    public void write(int b) throws IOException {
        Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
        this.oneByte[0] = (byte)b;
        this.write(this.oneByte, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    public static CipherOutputStream getInstance(OutputStream out, StreamCipher cipher) {
        if (out instanceof WrappedByteArrayOutputStream) {
            return new DirectStreamCipherOutputStream((WrappedByteArrayOutputStream)out, cipher);
        }
        return new StreamCipherOutputStream(out, cipher);
    }

    public static CipherOutputStream getInstance(OutputStream out, BufferedBlockCipher cipher) {
        if (out instanceof WrappedByteArrayOutputStream) {
            return new DirectBufferedCipherOutputStream((WrappedByteArrayOutputStream)out, cipher);
        }
        return new BufferedCipherOutputStream(out, cipher);
    }

    public static CipherOutputStream getInstance(OutputStream out, AEADCipher cipher) {
        if (out instanceof WrappedByteArrayOutputStream) {
            return new DirectAEADOutputStream((WrappedByteArrayOutputStream)out, cipher);
        }
        return new AEADOutputStream(out, cipher);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class DirectAEADOutputStream
    extends CipherOutputStreamImpl {
        private final AEADCipher aeadBlockCipher;
        private final WrappedByteArrayOutputStream directOut;

        public DirectAEADOutputStream(WrappedByteArrayOutputStream out, AEADCipher cipher) {
            super(cipher.getAlgorithmName(), out);
            this.directOut = out;
            this.aeadBlockCipher = cipher;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
            int outLen = this.aeadBlockCipher.processBytes(b, off, len, this.directOut.getBuffer(), this.directOut.getOffset());
            this.directOut.moveOffset(outLen);
        }

        @Override
        public void close() throws IOException {
            IOException error;
            block7: {
                Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
                error = null;
                try {
                    int outLen = this.aeadBlockCipher.doFinal(this.directOut.getBuffer(), this.directOut.getOffset());
                    this.directOut.moveOffset(outLen);
                }
                catch (InvalidCipherTextException e) {
                    error = new org.bouncycastle.crypto.InvalidCipherTextException("Error finalising cipher data: " + e.getMessage(), e);
                }
                catch (IllegalStateException e) {
                    error = new StreamException(e.getMessage(), e.getCause());
                }
                catch (Exception e) {
                    error = new StreamIOException("Error closing stream: ", e);
                }
                try {
                    this.flush();
                }
                catch (IOException e) {
                    if (error != null) break block7;
                    error = e;
                }
            }
            if (error != null) {
                throw error;
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class AEADOutputStream
    extends CipherOutputStreamImpl {
        private final AEADCipher aeadBlockCipher;
        private byte[] buf;

        public AEADOutputStream(OutputStream out, AEADCipher cipher) {
            super(cipher.getAlgorithmName(), out);
            this.aeadBlockCipher = cipher;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
            while (len > 0) {
                this.ensureCapacity(32768, false);
                int outLen = this.aeadBlockCipher.processBytes(b, off, len < 32768 ? len : 32768, this.buf, 0);
                if (outLen != 0) {
                    this.out.write(this.buf, 0, outLen);
                }
                off += 32768;
                len -= 32768;
            }
        }

        private void ensureCapacity(int updateSize, boolean finalOutput) {
            int bufLen = finalOutput ? this.aeadBlockCipher.getOutputSize(updateSize) : this.aeadBlockCipher.getUpdateOutputSize(updateSize);
            if (this.buf == null) {
                this.buf = new byte[bufLen];
            } else if (this.buf.length < bufLen) {
                Arrays.clear(this.buf);
                this.buf = new byte[bufLen];
            }
        }

        @Override
        public void close() throws IOException {
            IOException error;
            block15: {
                Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
                this.ensureCapacity(0, true);
                error = null;
                try {
                    int outLen = this.aeadBlockCipher.doFinal(this.buf, 0);
                    if (outLen != 0) {
                        this.out.write(this.buf, 0, outLen);
                    }
                }
                catch (InvalidCipherTextException e) {
                    error = new org.bouncycastle.crypto.InvalidCipherTextException("Error finalising cipher data: " + e.getMessage(), e);
                }
                catch (IllegalStateException e) {
                    error = new StreamException(e.getMessage(), e.getCause());
                }
                catch (Exception e) {
                    error = new StreamIOException("Error closing stream: ", e);
                }
                finally {
                    if (this.buf != null) {
                        Arrays.clear(this.buf);
                    }
                }
                try {
                    this.flush();
                }
                catch (IOException e) {
                    if (error != null) break block15;
                    error = e;
                }
            }
            if (error != null) {
                throw error;
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class DirectBufferedCipherOutputStream
    extends CipherOutputStreamImpl {
        private final BufferedBlockCipher bufferedBlockCipher;
        private final WrappedByteArrayOutputStream directOut;

        public DirectBufferedCipherOutputStream(WrappedByteArrayOutputStream out, BufferedBlockCipher cipher) {
            super(cipher.getUnderlyingCipher().getAlgorithmName(), out);
            this.directOut = out;
            this.bufferedBlockCipher = cipher;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
            int outLen = this.bufferedBlockCipher.processBytes(b, off, len, this.directOut.getBuffer(), this.directOut.getOffset());
            this.directOut.moveOffset(outLen);
        }

        @Override
        public void close() throws IOException {
            IOException error;
            block7: {
                Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
                error = null;
                try {
                    int outLen = this.bufferedBlockCipher.doFinal(this.directOut.getBuffer(), this.directOut.getOffset());
                    this.directOut.moveOffset(outLen);
                }
                catch (InvalidCipherTextException e) {
                    error = new org.bouncycastle.crypto.InvalidCipherTextException("Error finalising cipher data: " + e.getMessage(), e);
                }
                catch (IllegalStateException e) {
                    error = new StreamException(e.getMessage(), e.getCause());
                }
                catch (Exception e) {
                    error = new StreamIOException("Error closing stream: ", e);
                }
                try {
                    this.flush();
                }
                catch (IOException e) {
                    if (error != null) break block7;
                    error = e;
                }
            }
            if (error != null) {
                throw error;
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class BufferedCipherOutputStream
    extends CipherOutputStreamImpl {
        private final BufferedBlockCipher bufferedBlockCipher;
        private byte[] buf;

        public BufferedCipherOutputStream(OutputStream out, BufferedBlockCipher cipher) {
            super(cipher.getUnderlyingCipher().getAlgorithmName(), out);
            this.bufferedBlockCipher = cipher;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
            while (len > 0) {
                this.ensureCapacity(32768, false);
                int outLen = this.bufferedBlockCipher.processBytes(b, off, len < 32768 ? len : 32768, this.buf, 0);
                if (outLen != 0) {
                    this.out.write(this.buf, 0, outLen);
                }
                off += 32768;
                len -= 32768;
            }
        }

        private void ensureCapacity(int updateSize, boolean finalOutput) {
            int bufLen = finalOutput ? this.bufferedBlockCipher.getOutputSize(updateSize) : this.bufferedBlockCipher.getUpdateOutputSize(updateSize);
            if (this.buf == null) {
                this.buf = new byte[bufLen];
            } else if (this.buf.length < bufLen) {
                Arrays.clear(this.buf);
                this.buf = new byte[bufLen];
            }
        }

        @Override
        public void close() throws IOException {
            IOException error;
            block15: {
                Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
                this.ensureCapacity(0, true);
                error = null;
                try {
                    int outLen = this.bufferedBlockCipher.doFinal(this.buf, 0);
                    if (outLen != 0) {
                        this.out.write(this.buf, 0, outLen);
                    }
                }
                catch (InvalidCipherTextException e) {
                    error = new org.bouncycastle.crypto.InvalidCipherTextException("Error finalising cipher data: " + e.getMessage(), e);
                }
                catch (IllegalStateException e) {
                    error = new StreamException(e.getMessage(), e.getCause());
                }
                catch (Exception e) {
                    error = new StreamIOException("Error closing stream: ", e);
                }
                finally {
                    if (this.buf != null) {
                        Arrays.clear(this.buf);
                    }
                }
                try {
                    this.flush();
                }
                catch (IOException e) {
                    if (error != null) break block15;
                    error = e;
                }
            }
            if (error != null) {
                throw error;
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class DirectStreamCipherOutputStream
    extends CipherOutputStreamImpl {
        private StreamCipher streamCipher;
        private final WrappedByteArrayOutputStream directOut;

        public DirectStreamCipherOutputStream(WrappedByteArrayOutputStream out, StreamCipher cipher) {
            super(cipher.getAlgorithmName(), out);
            this.directOut = out;
            this.streamCipher = cipher;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
            int outLen = this.streamCipher.processBytes(b, off, len, this.directOut.getBuffer(), this.directOut.getOffset());
            this.directOut.moveOffset(outLen);
        }

        @Override
        public void close() throws IOException {
            IOException error;
            block6: {
                Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
                error = null;
                try {
                    this.streamCipher.reset();
                }
                catch (IllegalStateException e) {
                    error = new StreamException(e.getMessage(), e.getCause());
                }
                catch (Exception e) {
                    error = new StreamIOException("Error closing stream: ", e);
                }
                try {
                    this.flush();
                }
                catch (IOException e) {
                    if (error != null) break block6;
                    error = e;
                }
            }
            if (error != null) {
                throw error;
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class StreamCipherOutputStream
    extends CipherOutputStreamImpl {
        private final StreamCipher streamCipher;
        private final byte[] buf;

        public StreamCipherOutputStream(OutputStream out, StreamCipher cipher) {
            super(cipher.getAlgorithmName(), out);
            this.streamCipher = cipher;
            this.buf = new byte[32768];
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
            while (len > 0) {
                int outLen = this.streamCipher.processBytes(b, off, len < 32768 ? len : 32768, this.buf, 0);
                if (outLen != 0) {
                    this.out.write(this.buf, 0, outLen);
                }
                off += 32768;
                len -= 32768;
            }
        }

        @Override
        public void close() throws IOException {
            IOException error;
            block11: {
                Utils.approvedModeCheck(this.isApprovedMode, this.algorithmName);
                error = null;
                try {
                    this.streamCipher.reset();
                }
                catch (IllegalStateException e) {
                    error = new StreamException(e.getMessage(), e.getCause());
                }
                catch (Exception e) {
                    error = new StreamIOException("Error closing stream: ", e);
                }
                finally {
                    Arrays.clear(this.buf);
                }
                try {
                    this.flush();
                }
                catch (IOException e) {
                    if (error != null) break block11;
                    error = e;
                }
            }
            if (error != null) {
                throw error;
            }
        }
    }
}

