/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.DigestAlgorithm;
import org.bouncycastle.crypto.PasswordBasedDeriver;
import org.bouncycastle.crypto.PasswordBasedDeriverFactory;
import org.bouncycastle.crypto.PasswordConverter;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.crypto.general.GeneralParameters;
import org.bouncycastle.crypto.general.GuardedPasswordBasedDeriverFactory;
import org.bouncycastle.crypto.general.OpenSSLPBEParametersGenerator;
import org.bouncycastle.crypto.general.PKCS12ParametersGenerator;
import org.bouncycastle.crypto.general.PKCS5S1ParametersGenerator;
import org.bouncycastle.crypto.general.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.general.Register;
import org.bouncycastle.crypto.general.SecureHash;
import org.bouncycastle.crypto.general.Utils;
import org.bouncycastle.util.Arrays;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class PBKD {
    private static final GeneralAlgorithm ALGORITHM_PBKDF2 = new GeneralAlgorithm("PBKDF2");
    private static final GeneralAlgorithm ALGORITHM_PBKDF1 = new GeneralAlgorithm("PBKDF1");
    private static final GeneralAlgorithm ALGORITHM_PKCS12 = new GeneralAlgorithm("PKCS12");
    private static final GeneralAlgorithm ALGORITHM_OpenSSL = new GeneralAlgorithm("OpenSSL");
    public static final ParametersBuilder PBKDF1 = new ParametersBuilder(ALGORITHM_PBKDF1, FipsSHS.Algorithm.SHA1);
    public static final ParametersBuilder PBKDF2 = new ParametersBuilder(ALGORITHM_PBKDF2, FipsSHS.Algorithm.SHA1_HMAC);
    public static final ParametersBuilder PKCS12 = new ParametersBuilder(ALGORITHM_PKCS12, FipsSHS.Algorithm.SHA1);
    public static final OpenSSLParametersBuilder OpenSSL = new OpenSSLParametersBuilder();
    private static Map<Algorithm, PasswordBasedDeriverFactory<Parameters>> deriverTable = new HashMap<Algorithm, PasswordBasedDeriverFactory<Parameters>>();

    private PBKD() {
    }

    static {
        deriverTable.put(ALGORITHM_PBKDF2, new PBKDF2DeriverFactory());
        deriverTable.put(ALGORITHM_PBKDF1, new PBKDF1DeriverFactory());
        deriverTable.put(ALGORITHM_PKCS12, new PKCS12DeriverFactory());
        deriverTable.put(ALGORITHM_OpenSSL, new OpenSSLDeriverFactory());
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class OpenSSLDeriverFactory
    extends GuardedPasswordBasedDeriverFactory<Parameters> {
        private OpenSSLDeriverFactory() {
        }

        @Override
        public PasswordBasedDeriver<Parameters> createDeriver(final Parameters parameters) {
            if (parameters.getPRF() != SecureHash.Algorithm.MD5) {
                throw new IllegalArgumentException("OpenSSL PBKDF only defined for MD5");
            }
            final OpenSSLPBEParametersGenerator<Parameters> gen = new OpenSSLPBEParametersGenerator<Parameters>(parameters);
            gen.init(parameters.getPassword(), parameters.getSalt(), parameters.getIterationCount());
            return new PasswordBasedDeriver<Parameters>(){

                @Override
                public Parameters getParameters() {
                    Utils.approveModeCheck(parameters.getAlgorithm());
                    return parameters;
                }

                @Override
                public byte[] deriveKey(PasswordBasedDeriver.KeyType keyType, int keySizeInBytes) {
                    Utils.approveModeCheck(parameters.getAlgorithm());
                    return gen.deriveKey(keyType, keySizeInBytes);
                }

                @Override
                public byte[][] deriveKeyAndIV(PasswordBasedDeriver.KeyType keyType, int keySizeInBytes, int ivSizeInBytes) {
                    Utils.approveModeCheck(parameters.getAlgorithm());
                    return gen.deriveKeyAndIV(keyType, keySizeInBytes, ivSizeInBytes);
                }
            };
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class PKCS12DeriverFactory
    extends GuardedPasswordBasedDeriverFactory<Parameters> {
        private PKCS12DeriverFactory() {
        }

        @Override
        public PasswordBasedDeriver<Parameters> createDeriver(final Parameters parameters) {
            final PKCS12ParametersGenerator<Parameters> gen = new PKCS12ParametersGenerator<Parameters>(parameters, Register.createDigest(parameters.getPRF()));
            gen.init(parameters.getPassword(), parameters.getSalt(), parameters.getIterationCount());
            return new PasswordBasedDeriver<Parameters>(){

                @Override
                public Parameters getParameters() {
                    Utils.approveModeCheck(parameters.getAlgorithm());
                    return parameters;
                }

                @Override
                public byte[] deriveKey(PasswordBasedDeriver.KeyType keyType, int keySizeInBytes) {
                    Utils.approveModeCheck(parameters.getAlgorithm());
                    return gen.deriveKey(keyType, keySizeInBytes);
                }

                @Override
                public byte[][] deriveKeyAndIV(PasswordBasedDeriver.KeyType keyType, int keySizeInBytes, int ivSizeInBytes) {
                    Utils.approveModeCheck(parameters.getAlgorithm());
                    return gen.deriveKeyAndIV(keyType, keySizeInBytes, ivSizeInBytes);
                }
            };
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class PBKDF2DeriverFactory
    extends GuardedPasswordBasedDeriverFactory<Parameters> {
        private PBKDF2DeriverFactory() {
        }

        @Override
        public PasswordBasedDeriver<Parameters> createDeriver(final Parameters parameters) {
            final PKCS5S2ParametersGenerator<Parameters> gen = new PKCS5S2ParametersGenerator<Parameters>(parameters, Register.createHMac(parameters.getPRF()));
            gen.init(parameters.getPassword(), parameters.getSalt(), parameters.getIterationCount());
            return new PasswordBasedDeriver<Parameters>(){

                @Override
                public Parameters getParameters() {
                    return parameters;
                }

                @Override
                public byte[] deriveKey(PasswordBasedDeriver.KeyType keyType, int keySizeInBytes) {
                    Utils.approveModeCheck(parameters.getAlgorithm());
                    return gen.deriveKey(keyType, keySizeInBytes);
                }

                @Override
                public byte[][] deriveKeyAndIV(PasswordBasedDeriver.KeyType keyType, int keySizeInBytes, int ivSizeInBytes) {
                    Utils.approveModeCheck(parameters.getAlgorithm());
                    return gen.deriveKeyAndIV(keyType, keySizeInBytes, ivSizeInBytes);
                }
            };
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class PBKDF1DeriverFactory
    extends GuardedPasswordBasedDeriverFactory<Parameters> {
        private PBKDF1DeriverFactory() {
        }

        @Override
        public PasswordBasedDeriver<Parameters> createDeriver(final Parameters parameters) {
            final PKCS5S1ParametersGenerator<Parameters> gen = new PKCS5S1ParametersGenerator<Parameters>(parameters, Register.createDigest(parameters.getPRF()));
            gen.init(parameters.getPassword(), parameters.getSalt(), parameters.getIterationCount());
            return new PasswordBasedDeriver<Parameters>(){

                @Override
                public Parameters getParameters() {
                    Utils.approveModeCheck(parameters.getAlgorithm());
                    return parameters;
                }

                @Override
                public byte[] deriveKey(PasswordBasedDeriver.KeyType keyType, int keySizeInBytes) {
                    Utils.approveModeCheck(parameters.getAlgorithm());
                    return gen.deriveKey(keyType, keySizeInBytes);
                }

                @Override
                public byte[][] deriveKeyAndIV(PasswordBasedDeriver.KeyType keyType, int keySizeInBytes, int ivSizeInBytes) {
                    Utils.approveModeCheck(parameters.getAlgorithm());
                    return gen.deriveKeyAndIV(keyType, keySizeInBytes, ivSizeInBytes);
                }
            };
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class DeriverFactory
    extends GuardedPasswordBasedDeriverFactory<Parameters> {
        @Override
        public PasswordBasedDeriver<Parameters> createDeriver(Parameters parameters) {
            return ((PasswordBasedDeriverFactory)deriverTable.get(parameters.getAlgorithm())).createDeriver(parameters);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class Parameters
    extends GeneralParameters<Algorithm> {
        private final DigestAlgorithm digestAlgorithm;
        private final PasswordConverter converter;
        private final byte[] password;
        private final byte[] salt;
        private final int iterationCount;

        private Parameters(GeneralAlgorithm algorithm, DigestAlgorithm digestAlgorithm, PasswordConverter converter, byte[] password, int iterationCount, byte[] salt) {
            super(algorithm);
            this.digestAlgorithm = digestAlgorithm;
            this.converter = converter;
            this.password = password;
            this.iterationCount = iterationCount;
            this.salt = salt;
        }

        private Parameters(GeneralAlgorithm algorithm, DigestAlgorithm digestAlgorithm, PasswordConverter converter, char[] password) {
            this(algorithm, digestAlgorithm, converter, converter.convert(password), 1024, new byte[20]);
        }

        public Parameters withSalt(byte[] salt) {
            return new Parameters((GeneralAlgorithm)this.getAlgorithm(), this.digestAlgorithm, this.converter, this.getPassword(), this.iterationCount, Arrays.clone(salt));
        }

        public Parameters withIterationCount(int iterationCount) {
            return new Parameters((GeneralAlgorithm)this.getAlgorithm(), this.digestAlgorithm, this.converter, this.getPassword(), iterationCount, this.salt);
        }

        byte[] getPassword() {
            return Arrays.clone(this.password);
        }

        public DigestAlgorithm getPRF() {
            return this.digestAlgorithm;
        }

        public byte[] getSalt() {
            return Arrays.clone(this.salt);
        }

        public int getIterationCount() {
            return this.iterationCount;
        }

        public PasswordConverter getConverter() {
            return this.converter;
        }

        protected void finalize() throws Throwable {
            super.finalize();
            Arrays.fill(this.password, (byte)0);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class OpenSSLParametersBuilder
    extends GeneralParameters {
        OpenSSLParametersBuilder() {
            super(ALGORITHM_OpenSSL);
        }

        public Parameters using(byte[] password) {
            return new Parameters((GeneralAlgorithm)this.getAlgorithm(), SecureHash.Algorithm.MD5, null, Arrays.clone(password), 1024, new byte[20]);
        }

        public Parameters using(PasswordConverter converter, char[] password) {
            return new Parameters((GeneralAlgorithm)this.getAlgorithm(), SecureHash.Algorithm.MD5, converter, converter.convert(password), 1024, new byte[20]);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class ParametersBuilder
    extends GeneralParameters {
        private final DigestAlgorithm defaultPrf;

        ParametersBuilder(GeneralAlgorithm algorithm, DigestAlgorithm defaultPrf) {
            super(algorithm);
            this.defaultPrf = defaultPrf;
        }

        public Parameters using(byte[] password) {
            return this.using(this.defaultPrf, password);
        }

        public Parameters using(DigestAlgorithm digestAlgorithm, byte[] password) {
            return new Parameters((GeneralAlgorithm)this.getAlgorithm(), digestAlgorithm, null, Arrays.clone(password), 1024, new byte[20]);
        }

        public Parameters using(PasswordConverter converter, char[] password) {
            return new Parameters((GeneralAlgorithm)this.getAlgorithm(), this.defaultPrf, converter, password);
        }

        public Parameters using(DigestAlgorithm digestAlgorithm, PasswordConverter converter, char[] password) {
            return new Parameters((GeneralAlgorithm)this.getAlgorithm(), digestAlgorithm, converter, converter.convert(password), 1024, new byte[20]);
        }
    }
}

