/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.params.DsaParameterGenerationParameters;
import org.bouncycastle.crypto.internal.params.DsaParameters;
import org.bouncycastle.crypto.internal.params.DsaValidationParameters;
import org.bouncycastle.math.internal.Primes;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class DsaParametersGenerator {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private Digest digest;
    private int L;
    private int N;
    private int certainty;
    private int iterations;
    private SecureRandom random;
    private int usageIndex;

    public DsaParametersGenerator(Digest digest) {
        this.digest = digest;
    }

    public void init(DsaParameterGenerationParameters params) {
        int L = params.getL();
        int N = params.getN();
        if (L < 1024 || L > 3072 || L % 1024 != 0) {
            throw new IllegalArgumentException("L values must be between 1024 and 3072 and a multiple of 1024");
        }
        if (L == 1024 && N != 160) {
            throw new IllegalArgumentException("N must be 160 for L = 1024");
        }
        if (L == 2048 && N != 224 && N != 256) {
            throw new IllegalArgumentException("N must be 224 or 256 for L = 2048");
        }
        if (L == 3072 && N != 256) {
            throw new IllegalArgumentException("N must be 256 for L = 3072");
        }
        if (this.digest.getDigestSize() * 8 < N) {
            throw new IllegalStateException("Digest output size too small for value of N");
        }
        this.L = L;
        this.N = N;
        this.certainty = params.getCertainty();
        this.iterations = Math.max(DsaParametersGenerator.getMinimumIterations(L), (this.certainty + 1) / 2);
        this.random = params.getRandom();
        this.usageIndex = params.getUsageIndex();
    }

    public DsaParameters generateParameters() {
        return this.generateParameters_FIPS186_3();
    }

    private static BigInteger calculateGenerator_FIPS186_2(BigInteger p, BigInteger q, SecureRandom r) {
        BigInteger h;
        BigInteger g;
        BigInteger e = p.subtract(ONE).divide(q);
        BigInteger pSub2 = p.subtract(TWO);
        while ((g = (h = BigIntegers.createRandomInRange(TWO, pSub2, r)).modPow(e, p)).bitLength() <= 1) {
        }
        return g;
    }

    /*
     * Unable to fully structure code
     */
    private DsaParameters generateParameters_FIPS186_3() {
        d = this.digest;
        outlen = d.getDigestSize() * 8;
        seedlen = this.N;
        seed = new byte[seedlen / 8];
        n = (this.L - 1) / outlen;
        w = new byte[this.L / 8];
        output = new byte[d.getDigestSize()];
        block0: while (true) {
            this.random.nextBytes(seed);
            DsaParametersGenerator.hash(d, seed, output, 0);
            U = new BigInteger(1, output).mod(DsaParametersGenerator.ONE.shiftLeft(this.N - 1));
            q = U.setBit(0).setBit(this.N - 1);
            if (!this.isProbablePrime(q)) continue;
            offset = Arrays.clone(seed);
            counterLimit = 4 * this.L;
            counter = 0;
            while (true) {
                if (counter < counterLimit) ** break;
                continue block0;
                for (j = 1; j <= n; ++j) {
                    DsaParametersGenerator.inc(offset);
                    DsaParametersGenerator.hash(d, offset, w, w.length - j * output.length);
                }
                remaining = w.length - n * output.length;
                DsaParametersGenerator.inc(offset);
                DsaParametersGenerator.hash(d, offset, output, 0);
                System.arraycopy(output, output.length - remaining, w, 0, remaining);
                w[0] = (byte)(w[0] | -128);
                X = new BigInteger(1, w);
                c = X.mod(q.shiftLeft(1));
                p = X.subtract(c.subtract(DsaParametersGenerator.ONE));
                if (p.bitLength() == this.L && this.isProbablePrime(p)) {
                    if (this.usageIndex >= 0 && (g = DsaParametersGenerator.calculateGenerator_FIPS186_3_Verifiable(d, p, q, seed, this.usageIndex)) != null) {
                        return new DsaParameters(p, q, g, new DsaValidationParameters(seed, counter, this.usageIndex));
                    }
                    g = DsaParametersGenerator.calculateGenerator_FIPS186_3_Unverifiable(p, q, this.random);
                    return new DsaParameters(p, q, g, new DsaValidationParameters(seed, counter));
                }
                ++counter;
            }
            break;
        }
    }

    private boolean isProbablePrime(BigInteger x) {
        return !Primes.hasAnySmallFactors(x) && Primes.isMRProbablePrime(x, this.random, this.iterations);
    }

    static BigInteger calculateGenerator_FIPS186_3_Unverifiable(BigInteger p, BigInteger q, SecureRandom r) {
        return DsaParametersGenerator.calculateGenerator_FIPS186_2(p, q, r);
    }

    static BigInteger calculateGenerator_FIPS186_3_Verifiable(Digest d, BigInteger p, BigInteger q, byte[] seed, int index) {
        if ((index & 0xFF) != index) {
            throw new IllegalArgumentException("Usage index must be in range 0 to 255");
        }
        BigInteger e = p.subtract(ONE).divide(q);
        byte[] ggen = Hex.decode("6767656E");
        byte[] U = new byte[seed.length + ggen.length + 1 + 2];
        System.arraycopy(seed, 0, U, 0, seed.length);
        System.arraycopy(ggen, 0, U, seed.length, ggen.length);
        U[U.length - 3] = (byte)index;
        byte[] w = new byte[d.getDigestSize()];
        for (int count = 1; count < 65536; ++count) {
            DsaParametersGenerator.inc(U);
            DsaParametersGenerator.hash(d, U, w, 0);
            BigInteger W = new BigInteger(1, w);
            BigInteger g = W.modPow(e, p);
            if (g.compareTo(TWO) < 0) continue;
            return g;
        }
        return null;
    }

    private static void hash(Digest d, byte[] input, byte[] output, int outputPos) {
        d.update(input, 0, input.length);
        d.doFinal(output, outputPos);
    }

    private static int getMinimumIterations(int L) {
        return L <= 1024 ? 40 : 48 + 8 * ((L - 1) / 1024);
    }

    private static void inc(byte[] buf) {
        for (int i = buf.length - 1; i >= 0; --i) {
            byte b;
            buf[i] = b = (byte)(buf[i] + 1 & 0xFF);
            if (b != 0) break;
        }
    }
}

