/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ECPoint;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricECKey;
import org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import org.bouncycastle.crypto.asymmetric.ECDomainParametersID;
import org.bouncycastle.crypto.asymmetric.KeyUtils;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.Properties;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class AsymmetricECPublicKey
extends AsymmetricECKey
implements AsymmetricPublicKey {
    private final ECPoint q;

    public AsymmetricECPublicKey(Algorithm ecAlg, ECDomainParametersID domainParameterID, byte[] encodedPoint) {
        super(ecAlg, domainParameterID);
        this.q = KeyUtils.validated(this.getDomainParameters().getCurve(), encodedPoint);
    }

    public AsymmetricECPublicKey(Algorithm ecAlg, ECDomainParameters domainParameters, byte[] encodedPoint) {
        super(ecAlg, domainParameters);
        this.q = KeyUtils.validated(this.getDomainParameters().getCurve(), encodedPoint);
    }

    public AsymmetricECPublicKey(Algorithm ecAlg, ECDomainParametersID domainParameterID, ECPoint q) {
        super(ecAlg, domainParameterID);
        this.q = KeyUtils.validated(this.getDomainParameters().getCurve(), q);
    }

    public AsymmetricECPublicKey(Algorithm ecAlg, ECDomainParameters domainParameters, ECPoint q) {
        super(ecAlg, domainParameters);
        this.q = KeyUtils.validated(this.getDomainParameters().getCurve(), q);
    }

    public AsymmetricECPublicKey(Algorithm ecAlg, byte[] publicKeyInfoEncoding) {
        this(ecAlg, SubjectPublicKeyInfo.getInstance(publicKeyInfoEncoding));
    }

    public AsymmetricECPublicKey(Algorithm ecAlg, SubjectPublicKeyInfo publicKeyInfo) {
        super(ecAlg, publicKeyInfo.getAlgorithm());
        byte[] encodedPoint = publicKeyInfo.getPublicKeyData().getBytes();
        this.q = KeyUtils.validated(this.getDomainParameters().getCurve(), encodedPoint);
    }

    @Override
    public byte[] getEncoded() {
        return this.getEncoded(Properties.isOverrideSet("org.bouncycastle.ec.enable_pc"));
    }

    public byte[] getEncoded(boolean withPointCompression) {
        ECDomainParameters curveParams = this.getDomainParameters();
        X962Parameters params = KeyUtils.buildCurveParameters(curveParams);
        ASN1OctetString p = ASN1OctetString.getInstance(new X9ECPoint(this.getW(), withPointCompression).toASN1Primitive());
        SubjectPublicKeyInfo info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, params), p.getOctets());
        return KeyUtils.getEncodedInfo(info);
    }

    public ECPoint getW() {
        return this.q;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AsymmetricECPublicKey)) {
            return false;
        }
        AsymmetricECPublicKey other = (AsymmetricECPublicKey)o;
        if (!this.q.equals(other.q)) {
            return false;
        }
        return this.getDomainParameters().equals(other.getDomainParameters());
    }

    @Override
    public int hashCode() {
        int result = this.q.hashCode();
        result = 31 * result + this.getDomainParameters().hashCode();
        return result;
    }
}

