/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import java.io.IOException;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.sec.ECPrivateKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricECKey;
import org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import org.bouncycastle.crypto.asymmetric.ECDomainParametersID;
import org.bouncycastle.crypto.asymmetric.KeyUtils;
import org.bouncycastle.crypto.internal.Permissions;
import org.bouncycastle.math.ec.ECPoint;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class AsymmetricECPrivateKey
extends AsymmetricECKey
implements AsymmetricPrivateKey {
    private final AtomicBoolean hasBeenDestroyed = new AtomicBoolean(false);
    private final byte[] publicKey;
    private int hashCode;
    private BigInteger d;

    public AsymmetricECPrivateKey(Algorithm ecAlg, ECDomainParametersID domainParametersID, BigInteger s) {
        this(ecAlg, domainParametersID, s, null);
    }

    public AsymmetricECPrivateKey(Algorithm ecAlg, ECDomainParameters domainParameters, BigInteger s) {
        this(ecAlg, domainParameters, s, null);
    }

    public AsymmetricECPrivateKey(Algorithm ecAlg, ECDomainParameters domainParameters, BigInteger s, ECPoint w) {
        super(ecAlg, domainParameters);
        this.d = s;
        this.publicKey = this.extractPublicKeyBytes(w);
        this.hashCode = this.calculateHashCode();
    }

    public AsymmetricECPrivateKey(Algorithm ecAlg, ECDomainParametersID domainParametersID, BigInteger s, ECPoint w) {
        super(ecAlg, domainParametersID);
        this.d = s;
        this.publicKey = this.extractPublicKeyBytes(w);
        this.hashCode = this.calculateHashCode();
    }

    public AsymmetricECPrivateKey(Algorithm ecAlg, byte[] encoding) {
        this(ecAlg, PrivateKeyInfo.getInstance(encoding));
    }

    public AsymmetricECPrivateKey(Algorithm ecAlg, PrivateKeyInfo privateKeyInfo) {
        this(ecAlg, privateKeyInfo.getPrivateKeyAlgorithm(), AsymmetricECPrivateKey.parsePrivateKey(privateKeyInfo));
    }

    private AsymmetricECPrivateKey(Algorithm ecAlg, AlgorithmIdentifier algorithmIdentifier, ECPrivateKey privateKey) {
        super(ecAlg, algorithmIdentifier);
        this.d = privateKey.getKey();
        DERBitString wEnc = privateKey.getPublicKey();
        this.publicKey = wEnc == null ? null : wEnc.getBytes();
        this.hashCode = this.calculateHashCode();
    }

    private static ECPrivateKey parsePrivateKey(PrivateKeyInfo privateKeyInfo) {
        try {
            return ECPrivateKey.getInstance(privateKeyInfo.parsePrivateKey());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to parse EC private key: " + e.getMessage(), e);
        }
    }

    private byte[] extractPublicKeyBytes(ECPoint w) {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkDestroyed(this);
        if (w == null) {
            return null;
        }
        return w.getEncoded(false);
    }

    @Override
    public final byte[] getEncoded() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        KeyUtils.checkDestroyed(this);
        X962Parameters params = KeyUtils.buildCurveParameters(this.getDomainParameters());
        int orderBitLength = KeyUtils.getOrderBitLength(this.getDomainParameters());
        ECPrivateKey keyStructure = this.publicKey != null ? new ECPrivateKey(orderBitLength, this.getS(), new DERBitString(this.publicKey), params) : new ECPrivateKey(orderBitLength, this.getS(), params);
        return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, params), keyStructure);
    }

    @Override
    public final Algorithm getAlgorithm() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkDestroyed(this);
        return super.getAlgorithm();
    }

    @Override
    public final ECDomainParameters getDomainParameters() {
        this.checkApprovedOnlyModeStatus();
        ECDomainParameters dp = super.getDomainParameters();
        KeyUtils.checkDestroyed(this);
        return dp;
    }

    public BigInteger getS() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        BigInteger dVal = this.d;
        KeyUtils.checkDestroyed(this);
        return dVal;
    }

    @Override
    public void destroy() {
        this.checkApprovedOnlyModeStatus();
        if (!this.hasBeenDestroyed.getAndSet(true)) {
            this.d = null;
            this.hashCode = -1;
            super.zeroize();
        }
    }

    @Override
    public boolean isDestroyed() {
        this.checkApprovedOnlyModeStatus();
        return this.hasBeenDestroyed.get();
    }

    @Override
    public boolean equals(Object o) {
        this.checkApprovedOnlyModeStatus();
        if (this == o) {
            return true;
        }
        if (!(o instanceof AsymmetricECPrivateKey)) {
            return false;
        }
        AsymmetricECPrivateKey other = (AsymmetricECPrivateKey)o;
        other.checkApprovedOnlyModeStatus();
        if (!this.getS().equals(other.getS())) {
            return false;
        }
        return this.getDomainParameters().equals(other.getDomainParameters());
    }

    @Override
    public int hashCode() {
        this.checkApprovedOnlyModeStatus();
        return this.hashCode;
    }

    private int calculateHashCode() {
        int result = this.d.hashCode();
        result = 31 * result + this.getDomainParameters().hashCode();
        return result;
    }
}

