/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DSAParameter;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricKey;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.asymmetric.DSADomainParameters;
import org.bouncycastle.crypto.asymmetric.KeyUtils;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class AsymmetricDSAKey
implements AsymmetricKey {
    private static final Set<ASN1ObjectIdentifier> dsaOids = new HashSet<ASN1ObjectIdentifier>(3);
    private final boolean approvedModeOnly = CryptoServicesRegistrar.isInApprovedOnlyMode();
    private Algorithm algorithm;
    private DSADomainParameters domainParameters;

    AsymmetricDSAKey(Algorithm algorithm, DSADomainParameters domainParameters) {
        this.algorithm = algorithm;
        this.domainParameters = domainParameters;
    }

    AsymmetricDSAKey(Algorithm algorithm, AlgorithmIdentifier algorithmIdentifier) {
        this.algorithm = algorithm;
        this.domainParameters = AsymmetricDSAKey.decodeDomainParameters(algorithmIdentifier);
    }

    private static DSADomainParameters decodeDomainParameters(AlgorithmIdentifier algorithmIdentifier) {
        if (!dsaOids.contains(algorithmIdentifier.getAlgorithm())) {
            throw new IllegalArgumentException("Unknown algorithm type: " + algorithmIdentifier.getAlgorithm());
        }
        if (KeyUtils.isNotNull(algorithmIdentifier.getParameters())) {
            DSAParameter params = DSAParameter.getInstance(algorithmIdentifier.getParameters());
            return new DSADomainParameters(params.getP(), params.getQ(), params.getG());
        }
        return null;
    }

    @Override
    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public DSADomainParameters getDomainParameters() {
        return this.domainParameters;
    }

    protected final boolean isThreadCorrectMode() {
        return this.approvedModeOnly == CryptoServicesRegistrar.isInApprovedOnlyMode();
    }

    protected final void checkApprovedOnlyModeStatus() {
        if (!this.isThreadCorrectMode()) {
            throw new FipsUnapprovedOperationError("No access to key in current thread.");
        }
    }

    protected void zeroize() {
        this.algorithm = null;
        this.domainParameters = null;
    }

    static {
        dsaOids.add(X9ObjectIdentifiers.id_dsa);
        dsaOids.add(X9ObjectIdentifiers.id_dsa_with_sha1);
        dsaOids.add(OIWObjectIdentifiers.dsaWithSHA1);
    }
}

