/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class BERSet
extends ASN1Set {
    public BERSet() {
    }

    public BERSet(ASN1Encodable element) {
        super(element);
    }

    public BERSet(ASN1EncodableVector elementVector) {
        super(elementVector, false);
    }

    public BERSet(ASN1Encodable[] elements) {
        super(elements, false);
    }

    BERSet(boolean isSorted, ASN1Encodable[] elements) {
        super(isSorted, elements);
    }

    @Override
    int encodedLength() throws IOException {
        int count = this.elements.length;
        int totalLength = 0;
        for (int i = 0; i < count; ++i) {
            ASN1Primitive p = this.elements[i].toASN1Primitive();
            totalLength += p.encodedLength();
        }
        return 2 + totalLength + 2;
    }

    @Override
    void encode(ASN1OutputStream out, boolean withTag) throws IOException {
        out.writeEncodedIndef(withTag, 49, this.elements);
    }
}

