/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.spec;

import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import org.bouncycastle.crypto.asymmetric.GOST3410DomainParameters;
import org.bouncycastle.crypto.asymmetric.GOST3410Parameters;
import org.bouncycastle.jcajce.spec.ECDomainParameterSpec;
import org.bouncycastle.jcajce.spec.GOST3410DomainParameterSpec;

public final class GOST3410ParameterSpec<T extends AlgorithmParameterSpec>
implements AlgorithmParameterSpec {
    private GOST3410Parameters parameters;

    public GOST3410ParameterSpec(GOST3410Parameters parameters) {
        this.parameters = parameters;
    }

    public ASN1ObjectIdentifier getPublicKeyParamSet() {
        return this.parameters.getPublicKeyParamSet();
    }

    public ASN1ObjectIdentifier getDigestParamSet() {
        return this.parameters.getDigestParamSet();
    }

    public ASN1ObjectIdentifier getEncryptionParamSet() {
        return this.parameters.getEncryptionParamSet();
    }

    public T getDomainParametersSpec() {
        if (this.parameters.getDomainParameters() instanceof GOST3410DomainParameters) {
            return (T)new GOST3410DomainParameterSpec((GOST3410DomainParameters)this.parameters.getDomainParameters());
        }
        return (T)new ECDomainParameterSpec((ECDomainParameters)this.parameters.getDomainParameters());
    }

    public boolean equals(Object o) {
        if (o instanceof GOST3410ParameterSpec) {
            GOST3410ParameterSpec other = (GOST3410ParameterSpec)o;
            return this.parameters.equals(other.parameters);
        }
        return false;
    }

    public int hashCode() {
        return this.parameters.hashCode();
    }
}

