/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import java.util.concurrent.atomic.AtomicReference;
import org.bouncycastle.crypto.EntropySource;
import org.bouncycastle.crypto.EntropySourceProvider;
import org.bouncycastle.crypto.SecureRandomProvider;
import org.bouncycastle.jcajce.provider.AsymmetricAlgorithmProvider;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.Strings;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ProvRandom
extends AsymmetricAlgorithmProvider {
    private static final String PREFIX = "org.bouncycastle.jcajce.provider.random.";

    ProvRandom() {
    }

    @Override
    public void configure(final BouncyCastleFipsProvider provider) {
        provider.setProperty("SecureRandom.DEFAULT ThreadSafe", "true");
        provider.addAlgorithmImplementation("SecureRandom.DEFAULT", "org.bouncycastle.jcajce.provider.random.DefSecureRandom", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new SecureRandomSpi(){

                    @Override
                    protected void engineSetSeed(byte[] bytes) {
                        SecureRandom random = provider.getDefaultSecureRandom();
                        random.setSeed(bytes);
                    }

                    @Override
                    protected void engineNextBytes(byte[] bytes) {
                        SecureRandom random = provider.getDefaultSecureRandom();
                        random.nextBytes(bytes);
                    }

                    @Override
                    protected byte[] engineGenerateSeed(int numBytes) {
                        SecureRandom random = provider.getDefaultSecureRandom();
                        return random.generateSeed(numBytes);
                    }
                };
            }
        });
        final PooledNonceSecureRandomProvider nonceDRBGProv = new PooledNonceSecureRandomProvider(provider);
        provider.setProperty("SecureRandom.NONCEANDIV ThreadSafe", "true");
        provider.addAlgorithmImplementation("SecureRandom.NONCEANDIV", "org.bouncycastle.jcajce.provider.random.NonceAndIVSecureRandom", new EngineCreator(){

            @Override
            public Object createInstance(Object constructorParameter) {
                return new SecureRandomSpi(){

                    @Override
                    protected void engineSetSeed(byte[] bytes) {
                        SecureRandom random = nonceDRBGProv.get();
                        random.setSeed(bytes);
                    }

                    @Override
                    protected void engineNextBytes(byte[] bytes) {
                        SecureRandom random = nonceDRBGProv.get();
                        random.nextBytes(bytes);
                    }

                    @Override
                    protected byte[] engineGenerateSeed(int numBytes) {
                        SecureRandom random = nonceDRBGProv.get();
                        return random.generateSeed(numBytes);
                    }
                };
            }
        });
    }

    private byte[] generatePersonalizationString() {
        return Arrays.concatenate(Strings.toByteArray("NonceAndIV"), Pack.longToLittleEndian(Thread.currentThread().getId()), Pack.longToLittleEndian(System.currentTimeMillis()));
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private class PooledNonceSecureRandomProvider
    implements SecureRandomProvider {
        private final AtomicReference<SecureRandom>[] providerDefaultRandom = new AtomicReference[BouncyCastleFipsProvider.POOL_SIZE];
        private final BouncyCastleFipsProvider provider;

        PooledNonceSecureRandomProvider(BouncyCastleFipsProvider provider) {
            this.provider = provider;
            for (int i = 0; i != this.providerDefaultRandom.length; ++i) {
                this.providerDefaultRandom[i] = new AtomicReference();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public SecureRandom get() {
            int rngIndex = (Thread.currentThread().hashCode() & BouncyCastleFipsProvider.POOL_SIZE - 1) % this.providerDefaultRandom.length;
            if (this.providerDefaultRandom[rngIndex].get() != null) return this.providerDefaultRandom[rngIndex].get();
            AtomicReference<SecureRandom>[] atomicReferenceArray = this.providerDefaultRandom;
            synchronized (this.providerDefaultRandom) {
                if (this.providerDefaultRandom[rngIndex].get() != null) return this.providerDefaultRandom[rngIndex].get();
                EntropySourceProvider entropySourceProvider = this.provider.getEntropySourceProvider();
                EntropySource seedSource = entropySourceProvider.get(this.provider.getProviderDefaultSecurityStrength() / 2 + 1);
                this.providerDefaultRandom[rngIndex].compareAndSet(null, this.provider.getProviderDefaultRandomBuilder().fromEntropySource(entropySourceProvider).setPersonalizationString(ProvRandom.this.generatePersonalizationString()).build(seedSource.getEntropy(), false, Strings.toByteArray("Bouncy Castle FIPS Provider Nonce/IV")));
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return this.providerDefaultRandom[rngIndex].get();
            }
        }
    }
}

