/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.asymmetric.AsymmetricDSAPublicKey;
import org.bouncycastle.jcajce.provider.DSAUtils;
import org.bouncycastle.jcajce.provider.KeyUtil;
import org.bouncycastle.jcajce.provider.ProvKey;
import org.bouncycastle.util.Arrays;

class ProvDSAPublicKey
implements DSAPublicKey,
ProvKey<AsymmetricDSAPublicKey> {
    private static final long serialVersionUID = 1752452449903495175L;
    private transient AsymmetricDSAPublicKey baseKey;

    ProvDSAPublicKey(Algorithm algorithm, DSAPublicKey baseKey) {
        this.baseKey = new AsymmetricDSAPublicKey(algorithm, DSAUtils.extractParams(baseKey.getParams()), baseKey.getY());
    }

    ProvDSAPublicKey(Algorithm algorithm, DSAPublicKeySpec keySpec) {
        this.baseKey = new AsymmetricDSAPublicKey(algorithm, DSAUtils.extractParams(keySpec), keySpec.getY());
    }

    ProvDSAPublicKey(AsymmetricDSAPublicKey baseKey) {
        this.baseKey = baseKey;
    }

    @Override
    public AsymmetricDSAPublicKey getBaseKey() {
        return this.baseKey;
    }

    @Override
    public String getAlgorithm() {
        return "DSA";
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        return this.baseKey.getEncoded();
    }

    @Override
    public BigInteger getY() {
        return this.baseKey.getY();
    }

    @Override
    public DSAParams getParams() {
        if (this.baseKey.getDomainParameters() == null) {
            return null;
        }
        return DSAUtils.convertParams(this.baseKey.getDomainParameters());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DSAPublicKey)) {
            return false;
        }
        if (o instanceof ProvDSAPublicKey) {
            ProvDSAPublicKey other = (ProvDSAPublicKey)o;
            return this.baseKey.equals(other.baseKey);
        }
        DSAPublicKey other = (DSAPublicKey)o;
        return Arrays.areEqual(this.getEncoded(), other.getEncoded());
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Algorithm alg = (Algorithm)in.readObject();
        byte[] enc = (byte[])in.readObject();
        this.baseKey = new AsymmetricDSAPublicKey(alg, enc);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.baseKey.getAlgorithm());
        out.writeObject(this.getEncoded());
    }

    public String toString() {
        return KeyUtil.publicKeyToString("DSA", this.baseKey.getY(), this.baseKey.getDomainParameters());
    }
}

