/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.util.dispose;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.crypto.util.dispose.Disposable;
import org.bouncycastle.util.Properties;

public class DisposalDaemon
implements Runnable {
    private static final Logger LOG = Logger.getLogger(DisposalDaemon.class.getName());
    private static ReferenceQueue<Disposable> referenceQueue = new ReferenceQueue();
    private static Set<ReferenceWrapperWithDisposerRunnable> refs = Collections.synchronizedSet(new HashSet());
    private static final ScheduledExecutorService cleanupExecutor;
    private static final DisposalDaemon disposalDaemon;
    private static final Thread disposalThread;
    private static final long cleanupDelay;
    private static final String CLEANUP_DELAY_PROP = "org.bouncycastle.native.cleanup_delay";

    private static void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                ReferenceWrapperWithDisposerRunnable item = (ReferenceWrapperWithDisposerRunnable)referenceQueue.poll();
                while (item != null) {
                    refs.remove(item);
                    item.dispose();
                    item = (ReferenceWrapperWithDisposerRunnable)referenceQueue.poll();
                }
            }
        });
    }

    public static void addDisposable(Disposable disposable) {
        ReferenceWrapperWithDisposerRunnable ref = new ReferenceWrapperWithDisposerRunnable(disposable, referenceQueue);
        refs.add(ref);
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    final ReferenceWrapperWithDisposerRunnable item = (ReferenceWrapperWithDisposerRunnable)referenceQueue.remove();
                    refs.remove(item);
                    cleanupExecutor.schedule(new Runnable(){

                        @Override
                        public void run() {
                            item.dispose();
                        }
                    }, cleanupDelay, TimeUnit.SECONDS);
                }
            }
            catch (InterruptedException iex) {
                Thread.currentThread().interrupt();
                continue;
            }
            catch (Throwable e) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("exception in disposal thread: " + e.getMessage());
                continue;
            }
            break;
        }
    }

    static {
        disposalDaemon = new DisposalDaemon();
        cleanupDelay = Properties.asInteger(CLEANUP_DELAY_PROP, 5);
        cleanupExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "BC Cleanup Executor");
                t.setDaemon(true);
                return t;
            }
        });
        disposalThread = new Thread((Runnable)disposalDaemon, "BC Disposal Daemon");
        disposalThread.setDaemon(true);
        disposalThread.start();
        DisposalDaemon.addShutdownHook();
    }

    private static class ReferenceWrapperWithDisposerRunnable
    extends PhantomReference<Disposable> {
        private final Runnable disposer;
        private final String label;

        public ReferenceWrapperWithDisposerRunnable(Disposable referent, ReferenceQueue<? super Disposable> q) {
            super(referent, q);
            this.disposer = referent.getDisposeAction();
            this.label = referent.toString();
        }

        public void dispose() {
            this.disposer.run();
        }

        public String toString() {
            return this.label;
        }
    }
}

