/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.modes.gcm;

import java.util.Vector;
import org.bouncycastle.crypto.internal.modes.gcm.GCMExponentiator;
import org.bouncycastle.crypto.internal.modes.gcm.GCMUtil;
import org.bouncycastle.util.Arrays;

public class Tables1kGCMExponentiator
implements GCMExponentiator {
    private Vector lookupPowX2;

    @Override
    public void init(byte[] x) {
        int[] y = GCMUtil.asInts(x);
        if (this.lookupPowX2 != null && Arrays.areEqual(y, (int[])this.lookupPowX2.elementAt(0))) {
            return;
        }
        this.lookupPowX2 = new Vector(8);
        this.lookupPowX2.addElement(y);
    }

    @Override
    public void exponentiateX(long pow, byte[] output) {
        int[] y = GCMUtil.oneAsInts();
        int bit = 0;
        while (pow > 0L) {
            if ((pow & 1L) != 0L) {
                this.ensureAvailable(bit);
                GCMUtil.multiply(y, (int[])this.lookupPowX2.elementAt(bit));
            }
            ++bit;
            pow >>>= 1;
        }
        GCMUtil.asBytes(y, output);
    }

    private void ensureAvailable(int bit) {
        int count = this.lookupPowX2.size();
        if (count <= bit) {
            int[] tmp = (int[])this.lookupPowX2.elementAt(count - 1);
            do {
                tmp = Arrays.clone(tmp);
                GCMUtil.multiply(tmp, tmp);
                this.lookupPowX2.addElement(tmp);
            } while (++count <= bit);
        }
    }
}

