/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.macs;

import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.DataLengthException;
import org.bouncycastle.crypto.internal.InvalidCipherTextException;
import org.bouncycastle.crypto.internal.Mac;
import org.bouncycastle.crypto.internal.modes.AEADBlockCipher;
import org.bouncycastle.crypto.internal.params.AEADParameters;
import org.bouncycastle.crypto.internal.params.KeyParameter;
import org.bouncycastle.crypto.internal.params.ParametersWithIV;

public class AEADCipherMac
implements Mac {
    private final AEADBlockCipher aeadCipher;
    private final int macLenInBits;

    public AEADCipherMac(AEADBlockCipher aeadCipher, int macLenInBits) {
        this.aeadCipher = aeadCipher;
        this.macLenInBits = macLenInBits;
    }

    @Override
    public void init(CipherParameters params) throws IllegalArgumentException {
        if (!(params instanceof ParametersWithIV)) {
            throw new IllegalArgumentException("AEAD cipher based MAC needs nonce/IV");
        }
        ParametersWithIV p = (ParametersWithIV)params;
        this.aeadCipher.init(true, new AEADParameters((KeyParameter)p.getParameters(), this.macLenInBits, p.getIV()));
    }

    @Override
    public String getAlgorithmName() {
        return this.aeadCipher.getAlgorithmName() + "MAC";
    }

    @Override
    public int getMacSize() {
        return (this.macLenInBits + 7) / 8;
    }

    @Override
    public void update(byte in) throws IllegalStateException {
        this.aeadCipher.processAADByte(in);
    }

    @Override
    public void update(byte[] in, int inOff, int len) throws DataLengthException, IllegalStateException {
        this.aeadCipher.processAADBytes(in, inOff, len);
    }

    @Override
    public int doFinal(byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        try {
            return this.aeadCipher.doFinal(out, outOff);
        }
        catch (InvalidCipherTextException e) {
            throw new IllegalStateException("Unable to create MAC tag:" + e.getMessage(), e);
        }
    }

    @Override
    public void reset() {
        this.aeadCipher.reset();
    }
}

