/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsEngineProvider;
import org.bouncycastle.crypto.internal.EngineProvider;

public final class FipsRegister {
    private static final Map<FipsAlgorithm, EngineProvider> providerMap = new HashMap<FipsAlgorithm, EngineProvider>();

    FipsRegister() {
    }

    public static void registerEngineProvider(FipsAlgorithm algorithm, FipsEngineProvider provider) {
        if (algorithm == null || provider == null) {
            throw new IllegalArgumentException("Arguments cannot be null");
        }
        providerMap.put(algorithm, provider);
    }

    static <T> EngineProvider<T> getProvider(FipsAlgorithm algorithm) {
        return providerMap.get(algorithm);
    }
}

