/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.PasswordBasedDeriver;
import org.bouncycastle.crypto.PasswordConverter;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsDigestAlgorithm;
import org.bouncycastle.crypto.fips.FipsParameters;
import org.bouncycastle.crypto.fips.FipsPasswordBasedDeriverFactory;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.crypto.fips.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.fips.SelfTestExecutor;
import org.bouncycastle.crypto.internal.PBEParametersGenerator;
import org.bouncycastle.crypto.internal.test.BasicKatTest;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;

public final class FipsPBKD {
    private static final FipsAlgorithm ALGORITHM_PBKDF2 = new FipsAlgorithm("PBKDF2");
    public static final ParametersBuilder PBKDF2;

    private FipsPBKD() {
    }

    static {
        Parameters parameters = new ParametersBuilder().using(FipsSHS.Algorithm.SHA256_HMAC, Strings.toByteArray("Legion of the Bouncy Castle")).withIterationCount(2048).withSalt(Hex.decode("0102030405060708090a0b0c0e0d0e0f"));
        PKCS5S2ParametersGenerator<Parameters> engine = new PKCS5S2ParametersGenerator<Parameters>(parameters, FipsSHS.createHMac(FipsSHS.Algorithm.SHA256_HMAC));
        SelfTestExecutor.validate(ALGORITHM_PBKDF2, engine, new PbkdfTest(parameters, Hex.decode("fb18073c0bc900343ad8280821938255")));
        PBKDF2 = new ParametersBuilder();
    }

    public static class DeriverFactory
    extends FipsPasswordBasedDeriverFactory<Parameters> {
        @Override
        public PasswordBasedDeriver<Parameters> createDeriver(final Parameters parameters) {
            final PKCS5S2ParametersGenerator<Parameters> gen = new PKCS5S2ParametersGenerator<Parameters>(parameters, FipsSHS.createHMac(parameters.getPRF()));
            gen.init(parameters.getPassword(), parameters.getSalt(), parameters.getIterationCount());
            return new PasswordBasedDeriver<Parameters>(){

                @Override
                public Parameters getParameters() {
                    return parameters;
                }

                @Override
                public byte[] deriveKey(PasswordBasedDeriver.KeyType keyType, int keySizeInBytes) {
                    return gen.deriveKey(keyType, keySizeInBytes);
                }

                @Override
                public byte[][] deriveKeyAndIV(PasswordBasedDeriver.KeyType keyType, int keySizeInBytes, int ivSizeInBytes) {
                    return gen.deriveKeyAndIV(keyType, keySizeInBytes, ivSizeInBytes);
                }
            };
        }
    }

    public static final class Parameters
    extends FipsParameters {
        private final FipsDigestAlgorithm digestAlgorithm;
        private final PasswordConverter converter;
        private final byte[] password;
        private final byte[] salt;
        private final int iterationCount;

        private Parameters(FipsDigestAlgorithm digestAlgorithm, PasswordConverter converter, byte[] password, int iterationCount, byte[] salt) {
            super(ALGORITHM_PBKDF2);
            this.digestAlgorithm = digestAlgorithm;
            this.converter = converter;
            this.password = password;
            this.iterationCount = iterationCount;
            this.salt = salt;
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                if (salt.length < 16) {
                    throw new FipsUnapprovedOperationError("salt must be at least 128 bits");
                }
                if (password.length < 14) {
                    throw new FipsUnapprovedOperationError("password must be at least 112 bits");
                }
            }
        }

        private Parameters(FipsDigestAlgorithm algorithm, PasswordConverter converter, char[] password) {
            this(algorithm, converter, converter.convert(password), 1024, new byte[20]);
        }

        public Parameters withSalt(byte[] salt) {
            return new Parameters(this.digestAlgorithm, this.converter, this.getPassword(), this.iterationCount, Arrays.clone(salt));
        }

        public Parameters withIterationCount(int iterationCount) {
            return new Parameters(this.digestAlgorithm, this.converter, this.getPassword(), iterationCount, this.salt);
        }

        synchronized byte[] getPassword() {
            return Arrays.clone(this.password);
        }

        public FipsDigestAlgorithm getPRF() {
            return this.digestAlgorithm;
        }

        public byte[] getSalt() {
            return Arrays.clone(this.salt);
        }

        public int getIterationCount() {
            return this.iterationCount;
        }

        public PasswordConverter getConverter() {
            return this.converter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() {
            Parameters parameters = this;
            synchronized (parameters) {
                Arrays.fill(this.password, (byte)0);
            }
        }
    }

    public static final class ParametersBuilder
    extends FipsParameters {
        ParametersBuilder() {
            super(ALGORITHM_PBKDF2);
        }

        public Parameters using(byte[] password) {
            return this.using(FipsSHS.Algorithm.SHA1_HMAC, password);
        }

        public Parameters using(FipsDigestAlgorithm algorithm, byte[] password) {
            return new Parameters(algorithm, null, Arrays.clone(password), 1024, new byte[20]);
        }

        public Parameters using(PasswordConverter converter, char[] password) {
            return new Parameters(FipsSHS.Algorithm.SHA1_HMAC, converter, password);
        }

        public Parameters using(FipsDigestAlgorithm algorithm, PasswordConverter converter, char[] password) {
            return new Parameters(algorithm, converter, converter.convert(password), 1024, new byte[20]);
        }
    }

    private static class PbkdfTest<T extends PBEParametersGenerator<Parameters>>
    implements BasicKatTest<T> {
        private final Parameters params;
        private final byte[] kat;

        PbkdfTest(Parameters params, byte[] kat) {
            this.params = params;
            this.kat = kat;
        }

        @Override
        public boolean hasTestPassed(T generator) {
            ((PBEParametersGenerator)generator).init(this.params.password, this.params.salt, this.params.iterationCount);
            byte[] result = generator.deriveKey(PasswordBasedDeriver.KeyType.CIPHER, 16);
            return Arrays.areEqual(result, this.kat);
        }
    }
}

