/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.security.SecureRandom;
import org.bouncycastle.crypto.fips.FipsSecureRandom;
import org.bouncycastle.crypto.internal.KeyGenerationParameters;

class CipherKeyGenerator {
    protected SecureRandom random;
    protected int strength;

    CipherKeyGenerator() {
    }

    public void init(KeyGenerationParameters param) {
        this.random = param.getRandom();
        this.strength = (param.getStrength() + 7) / 8;
    }

    public byte[] generateKey() {
        byte[] key = new byte[this.strength];
        if (this.random instanceof FipsSecureRandom) {
            FipsSecureRandom fipsRandom = (FipsSecureRandom)this.random;
            fipsRandom.reseed();
            fipsRandom.nextBytes(key);
        } else {
            this.random.nextBytes(key);
        }
        return key;
    }
}

