/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.DataLengthException;
import org.bouncycastle.crypto.internal.MultiBlockCipher;
import org.bouncycastle.crypto.internal.params.KeyParameter;
import org.bouncycastle.crypto.util.dispose.NativeDisposer;
import org.bouncycastle.crypto.util.dispose.NativeReference;

class AESNativeEngine
implements MultiBlockCipher {
    protected NativeReference wrapper = null;
    private int keyLen = 0;

    AESNativeEngine() {
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        if (params instanceof KeyParameter) {
            byte[] key = ((KeyParameter)params).getKey();
            switch (key.length) {
                case 16: 
                case 24: 
                case 32: {
                    this.wrapper = new ECBNativeRef(AESNativeEngine.makeNative(key.length, forEncryption));
                    this.keyLen = key.length * 8;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("key must be 16, 24 or 32 bytes");
                }
            }
            AESNativeEngine.init(this.wrapper.getReference(), key);
            return;
        }
        throw new IllegalArgumentException("invalid parameter passed to AES init - " + params.getClass().getName());
    }

    @Override
    public String getAlgorithmName() {
        return "AES";
    }

    @Override
    public int getBlockSize() {
        return AESNativeEngine.getBlockSize(0L);
    }

    @Override
    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        if (this.wrapper == null) {
            throw new IllegalStateException("not initialized");
        }
        return AESNativeEngine.process(this.wrapper.getReference(), in, inOff, 1, out, outOff);
    }

    @Override
    public int getMultiBlockSize() {
        return AESNativeEngine.getMultiBlockSize(0L);
    }

    @Override
    public int processBlocks(byte[] in, int inOff, int blockCount, byte[] out, int outOff) throws DataLengthException, IllegalStateException {
        if (this.wrapper == null) {
            throw new IllegalStateException("not initialized");
        }
        return AESNativeEngine.process(this.wrapper.getReference(), in, inOff, blockCount, out, outOff);
    }

    @Override
    public void reset() {
        if (this.wrapper == null) {
            return;
        }
        AESNativeEngine.reset(this.wrapper.getReference());
    }

    private static native void reset(long var0);

    private static native int process(long var0, byte[] var2, int var3, int var4, byte[] var5, int var6);

    private static native int getMultiBlockSize(long var0);

    private static native int getBlockSize(long var0);

    static native long makeNative(int var0, boolean var1);

    static native void dispose(long var0);

    static native void init(long var0, byte[] var2);

    public String toString() {
        return "AES[Native](" + this.keyLen + ")";
    }

    private static class Disposer
    extends NativeDisposer {
        Disposer(long ref) {
            super(ref);
        }

        @Override
        protected void dispose(long reference) {
            AESNativeEngine.dispose(reference);
        }
    }

    private static class ECBNativeRef
    extends NativeReference {
        public ECBNativeRef(long reference) {
            super(reference);
        }

        @Override
        protected Runnable createAction() {
            return new Disposer(this.reference);
        }
    }
}

