/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import java.lang.ref.WeakReference;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricKey;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.util.Properties;

public abstract class AsymmetricRSAKey
implements AsymmetricKey {
    protected static final AlgorithmIdentifier DEF_ALG_ID = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, DERNull.INSTANCE);
    protected static final AlgorithmIdentifier PSS_ALG_ID = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_RSASSA_PSS);
    private static final Set<ASN1ObjectIdentifier> rsaOids = new HashSet<ASN1ObjectIdentifier>(4);
    private final boolean approvedModeOnly;
    private final KeyMarker keyMarker;
    private Algorithm algorithm;
    private BigInteger modulus;
    protected final AlgorithmIdentifier rsaAlgIdentifier;
    private static WeakHashMap<BigInteger, WeakReference<KeyMarker>> markers;

    AsymmetricRSAKey(Algorithm algorithm, BigInteger modulus) {
        this.approvedModeOnly = CryptoServicesRegistrar.isInApprovedOnlyMode();
        this.algorithm = algorithm;
        this.keyMarker = AsymmetricRSAKey.getKeyMarker(modulus);
        this.modulus = this.keyMarker.modulus;
        this.rsaAlgIdentifier = algorithm.getName().equals("RSA/PSS") ? PSS_ALG_ID : DEF_ALG_ID;
    }

    AsymmetricRSAKey(Algorithm algorithm, AlgorithmIdentifier rsaAlgIdentifier, BigInteger modulus) {
        ASN1ObjectIdentifier keyAlgorithm = rsaAlgIdentifier.getAlgorithm();
        if (!rsaOids.contains(keyAlgorithm)) {
            throw new IllegalArgumentException("Unknown algorithm type: " + keyAlgorithm);
        }
        this.approvedModeOnly = CryptoServicesRegistrar.isInApprovedOnlyMode();
        this.algorithm = algorithm;
        this.rsaAlgIdentifier = rsaAlgIdentifier;
        this.keyMarker = AsymmetricRSAKey.getKeyMarker(modulus);
        this.modulus = this.keyMarker.modulus;
        if (keyAlgorithm.equals(PKCSObjectIdentifiers.id_RSASSA_PSS)) {
            this.keyMarker.canBeUsed(Usage.SIGN_OR_VERIFY);
        } else if (keyAlgorithm.equals(PKCSObjectIdentifiers.id_RSAES_OAEP)) {
            this.keyMarker.canBeUsed(Usage.ENCRYPT_OR_DECRYPT);
        }
    }

    @Override
    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public boolean canBeUsed(Usage usage) {
        return Properties.isOverrideSet("org.bouncycastle.rsa.allow_multi_use") || this.keyMarker.canBeUsed(usage);
    }

    protected void zeroize() {
        this.algorithm = null;
        this.modulus = null;
    }

    protected final boolean isThreadCorrectMode() {
        return this.approvedModeOnly == CryptoServicesRegistrar.isInApprovedOnlyMode();
    }

    protected final void checkApprovedOnlyModeStatus() {
        if (!this.isThreadCorrectMode()) {
            throw new FipsUnapprovedOperationError("No access to key in current thread.");
        }
    }

    static synchronized boolean isAlreadySeen(BigInteger modulus) {
        return markers.containsKey(modulus);
    }

    static synchronized KeyMarker getKeyMarker(BigInteger modulus) {
        KeyMarker marker = null;
        WeakReference<KeyMarker> markerRef = markers.get(modulus);
        if (markerRef != null) {
            marker = (KeyMarker)markerRef.get();
        }
        if (marker != null) {
            return marker;
        }
        marker = new KeyMarker(modulus);
        markerRef = new WeakReference<KeyMarker>(marker);
        markers.put(modulus, markerRef);
        return marker;
    }

    static {
        rsaOids.add(PKCSObjectIdentifiers.rsaEncryption);
        rsaOids.add(X509ObjectIdentifiers.id_ea_rsa);
        rsaOids.add(PKCSObjectIdentifiers.id_RSAES_OAEP);
        rsaOids.add(PKCSObjectIdentifiers.id_RSASSA_PSS);
        rsaOids.add(PKCSObjectIdentifiers.id_rsa_KEM);
        markers = new WeakHashMap();
    }

    private static class KeyMarker {
        private final AtomicReference<Usage> keyUsage = new AtomicReference<Object>(null);
        private final BigInteger modulus;

        KeyMarker(BigInteger modulus) {
            this.modulus = modulus;
        }

        public boolean canBeUsed(Usage usage) {
            return this.keyUsage.compareAndSet(null, usage) || this.keyUsage.get().equals((Object)usage) || this.keyUsage.compareAndSet(Usage.SIGN_OR_VERIFY, usage);
        }
    }

    public static enum Usage {
        SIGN_OR_VERIFY,
        ENCRYPT_OR_DECRYPT;

    }
}

