/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivateKey;
import javax.security.auth.Destroyable;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.crypto.asymmetric.AsymmetricXDHPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricXDHPublicKey;
import org.bouncycastle.jcajce.interfaces.XDHKey;
import org.bouncycastle.jcajce.provider.KeyUtil;
import org.bouncycastle.util.Arrays;

class ProvXDHPrivateKey
implements Destroyable,
XDHKey,
PrivateKey {
    static final long serialVersionUID = 1L;
    private transient AsymmetricXDHPrivateKey baseKey;

    ProvXDHPrivateKey(AsymmetricXDHPrivateKey privKey) {
        this.baseKey = privKey;
    }

    ProvXDHPrivateKey(PrivateKeyInfo keyInfo) throws IOException {
        this.baseKey = new AsymmetricXDHPrivateKey(keyInfo);
    }

    public String getAlgorithm() {
        return this.getBaseKey().getAlgorithm().getName();
    }

    public String getFormat() {
        KeyUtil.checkDestroyed(this);
        return "PKCS#8";
    }

    public byte[] getPublicData() {
        return this.getBaseKey().getPublicData();
    }

    public byte[] getEncoded() {
        return this.getBaseKey().getEncoded();
    }

    public void destroy() {
        this.baseKey.destroy();
    }

    public boolean isDestroyed() {
        return this.baseKey.isDestroyed();
    }

    public AsymmetricXDHPrivateKey getBaseKey() {
        KeyUtil.checkDestroyed(this);
        return this.baseKey;
    }

    public String toString() {
        if (this.isDestroyed()) {
            return KeyUtil.destroyedPrivateKeyToString("XDH");
        }
        AsymmetricXDHPublicKey pubKey = new AsymmetricXDHPublicKey(this.baseKey.getAlgorithm(), this.baseKey.getPublicData());
        return KeyUtil.keyToString("Private Key", this.getAlgorithm(), pubKey);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProvXDHPrivateKey)) {
            return false;
        }
        ProvXDHPrivateKey other = (ProvXDHPrivateKey)o;
        return Arrays.areEqual(other.getEncoded(), this.getEncoded());
    }

    public int hashCode() {
        return this.baseKey.hashCode();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] enc = (byte[])in.readObject();
        this.baseKey = new AsymmetricXDHPrivateKey(enc);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.isDestroyed()) {
            throw new IOException("key has been destroyed");
        }
        out.defaultWriteObject();
        out.writeObject(this.getEncoded());
    }
}

