/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.jcajce.PKIXCertStore;
import org.bouncycastle.jcajce.PKIXCertStoreSelector;
import org.bouncycastle.jcajce.PKIXExtendedBuilderParameters;
import org.bouncycastle.jcajce.provider.AnnotatedException;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.CertPathValidatorUtilities;
import org.bouncycastle.jcajce.provider.CertificateFactory;
import org.bouncycastle.jcajce.provider.PKIXCertPathValidatorSpi;

class PKIXCertPathBuilderSpi
extends CertPathBuilderSpi {
    private final BouncyCastleFipsProvider fipsProvider;
    private AnnotatedException certPathException;

    PKIXCertPathBuilderSpi(BouncyCastleFipsProvider fipsProvider) {
        this.fipsProvider = fipsProvider;
    }

    public CertPathBuilderResult engineBuild(CertPathParameters params) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        Collection targets;
        PKIXExtendedBuilderParameters pkixParams = null;
        if (params instanceof PKIXExtendedBuilderParameters) {
            pkixParams = (PKIXExtendedBuilderParameters)params;
        } else if (params instanceof PKIXBuilderParameters) {
            pkixParams = new PKIXExtendedBuilderParameters.Builder((PKIXBuilderParameters)params).build();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be an instance of " + PKIXBuilderParameters.class.getName() + " or " + PKIXExtendedBuilderParameters.class.getName() + ".");
        }
        ArrayList certPathList = new ArrayList();
        PKIXCertStoreSelector certSelect = pkixParams.getBaseParameters().getTargetConstraints();
        try {
            targets = CertPathValidatorUtilities.findCertificates(certSelect, pkixParams.getBaseParameters().getCertificateStores());
            targets.addAll(CertPathValidatorUtilities.findCertificates(certSelect, pkixParams.getBaseParameters().getCertStores()));
        }
        catch (AnnotatedException e) {
            throw new CertPathBuilderException("Error finding target certificate.", e);
        }
        if (targets.isEmpty()) {
            throw new CertPathBuilderException("No certificate found matching targetContraints.");
        }
        CertPathBuilderResult result = null;
        Iterator targetIter = targets.iterator();
        while (targetIter.hasNext() && result == null) {
            X509Certificate cert = (X509Certificate)targetIter.next();
            result = this.build(cert, pkixParams, certPathList);
        }
        if (result == null && this.certPathException != null) {
            throw new CertPathBuilderException(this.certPathException.getMessage(), this.certPathException.getCause());
        }
        if (result == null) {
            throw new CertPathBuilderException("Unable to find certificate chain.");
        }
        return result;
    }

    protected CertPathBuilderResult build(X509Certificate tbvCert, PKIXExtendedBuilderParameters pkixParams, List tbvPath) throws CertPathBuilderException {
        PKIXCertPathValidatorSpi validator;
        CertificateFactory cFact;
        if (tbvPath.contains(tbvCert)) {
            return null;
        }
        if (pkixParams.getExcludedCerts().contains(tbvCert)) {
            return null;
        }
        if (pkixParams.getMaxPathLength() != -1 && tbvPath.size() - 1 > pkixParams.getMaxPathLength()) {
            return null;
        }
        tbvPath.add(tbvCert);
        CertPathBuilderResult builderResult = null;
        try {
            cFact = new CertificateFactory(this.fipsProvider);
            validator = new PKIXCertPathValidatorSpi(this.fipsProvider);
        }
        catch (Exception e) {
            throw new CertPathBuilderException("Exception creating support classes: " + e.getMessage(), e);
        }
        try {
            if (CertPathValidatorUtilities.findTrustAnchor(tbvCert, pkixParams.getBaseParameters().getTrustAnchors(), pkixParams.getBaseParameters().getSigProvider()) != null) {
                CertPath certPath = null;
                PKIXCertPathValidatorResult result = null;
                try {
                    certPath = cFact.engineGenerateCertPath(tbvPath);
                }
                catch (Exception e) {
                    throw new AnnotatedException("Certification path could not be constructed from certificate list.", e);
                }
                try {
                    result = (PKIXCertPathValidatorResult)validator.engineValidate(certPath, pkixParams);
                }
                catch (Exception e) {
                    throw new AnnotatedException("Certification path could not be validated.", e);
                }
                return new PKIXCertPathBuilderResult(certPath, result.getTrustAnchor(), result.getPolicyTree(), result.getPublicKey());
            }
            ArrayList<PKIXCertStore> stores = new ArrayList<PKIXCertStore>();
            stores.addAll(pkixParams.getBaseParameters().getCertificateStores());
            try {
                stores.addAll(CertPathValidatorUtilities.getAdditionalStoresFromAltNames(tbvCert.getExtensionValue(Extension.issuerAlternativeName.getId()), pkixParams.getBaseParameters().getNamedCertificateStoreMap()));
            }
            catch (CertificateParsingException e) {
                throw new AnnotatedException("No additional X.509 stores can be added from certificate locations.", e);
            }
            HashSet issuers = new HashSet();
            try {
                issuers.addAll(CertPathValidatorUtilities.findIssuerCerts(tbvCert, pkixParams.getBaseParameters().getCertStores(), stores));
            }
            catch (AnnotatedException e) {
                throw new AnnotatedException("Cannot find issuer certificate for certificate in certification path.", e);
            }
            if (issuers.isEmpty()) {
                throw new AnnotatedException("No issuer certificate for certificate in certification path found.");
            }
            Iterator it = issuers.iterator();
            while (it.hasNext() && builderResult == null) {
                X509Certificate issuer = (X509Certificate)it.next();
                builderResult = this.build(issuer, pkixParams, tbvPath);
            }
        }
        catch (AnnotatedException e) {
            this.certPathException = e;
        }
        if (builderResult == null) {
            tbvPath.remove(tbvCert);
        }
        return builderResult;
    }
}

