/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce;

import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import org.bouncycastle.crypto.util.PBKDF2Config;
import org.bouncycastle.crypto.util.PBKDFConfig;
import org.bouncycastle.jcajce.BCLoadStoreParameter;

public class BCFKSLoadStoreParameter
extends BCLoadStoreParameter {
    private final PBKDFConfig storeConfig;
    private final EncryptionAlgorithm encAlg;
    private final MacAlgorithm macAlg;

    private BCFKSLoadStoreParameter(InputStream in, OutputStream out, PBKDFConfig storeConfig, KeyStore.ProtectionParameter protectionParameter, EncryptionAlgorithm encAlg, MacAlgorithm macAlg) {
        super(in, out, protectionParameter);
        this.storeConfig = storeConfig;
        this.encAlg = encAlg;
        this.macAlg = macAlg;
    }

    public PBKDFConfig getStorePBKDFConfig() {
        return this.storeConfig;
    }

    public EncryptionAlgorithm getStoreEncryptionAlgorithm() {
        return this.encAlg;
    }

    public MacAlgorithm getStoreMacAlgorithm() {
        return this.macAlg;
    }

    public static class Builder {
        private final OutputStream out;
        private final InputStream in;
        private final KeyStore.ProtectionParameter protectionParameter;
        private PBKDFConfig storeConfig = new PBKDF2Config.Builder().withIterationCount(16384).withSaltLength(64).withPRF(PBKDF2Config.PRF_SHA512).build();
        private EncryptionAlgorithm encAlg = EncryptionAlgorithm.AES256_CCM;
        private MacAlgorithm macAlg = MacAlgorithm.HmacSHA512;

        public Builder() {
            this((OutputStream)null, (KeyStore.ProtectionParameter)null);
        }

        public Builder(OutputStream out, char[] password) {
            this(out, (KeyStore.ProtectionParameter)new KeyStore.PasswordProtection(password));
        }

        public Builder(OutputStream out, KeyStore.ProtectionParameter protectionParameter) {
            this.in = null;
            this.out = out;
            this.protectionParameter = protectionParameter;
        }

        public Builder(InputStream in, char[] password) {
            this(in, (KeyStore.ProtectionParameter)new KeyStore.PasswordProtection(password));
        }

        public Builder(InputStream in, KeyStore.ProtectionParameter protectionParameter) {
            this.in = in;
            this.out = null;
            this.protectionParameter = protectionParameter;
        }

        public Builder withStorePBKDFConfig(PBKDFConfig storeConfig) {
            this.storeConfig = storeConfig;
            return this;
        }

        public Builder withStoreEncryptionAlgorithm(EncryptionAlgorithm encAlg) {
            this.encAlg = encAlg;
            return this;
        }

        public Builder withStoreMacAlgorithm(MacAlgorithm macAlg) {
            this.macAlg = macAlg;
            return this;
        }

        public BCFKSLoadStoreParameter build() {
            return new BCFKSLoadStoreParameter(this.in, this.out, this.storeConfig, this.protectionParameter, this.encAlg, this.macAlg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EncryptionAlgorithm {
        AES256_CCM,
        AES256_KWP;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MacAlgorithm {
        HmacSHA512,
        HmacSHA3_512;

    }
}

