/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import org.bouncycastle.crypto.CipherOutputStream;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.InputDecryptor;
import org.bouncycastle.crypto.OperatorUsingSecureRandom;
import org.bouncycastle.crypto.OutputDecryptor;
import org.bouncycastle.crypto.OutputEncryptor;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.SymmetricOperatorFactory;
import org.bouncycastle.crypto.fips.FipsStatus;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.crypto.internal.StreamCipher;
import org.bouncycastle.crypto.internal.io.CipherInputStream;
import org.bouncycastle.crypto.internal.io.CipherOutputStreamImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class GuardedSymmetricStreamOperatorFactory<T extends Parameters>
implements SymmetricOperatorFactory<T> {
    GuardedSymmetricStreamOperatorFactory() {
        if (!FipsStatus.isReady()) {
            throw new FipsUnapprovedOperationError("Module has not entered the ready state.");
        }
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved factory in approved mode");
        }
    }

    @Override
    public final OutputEncryptor<T> createOutputEncryptor(SymmetricKey key, T parameters) {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved algorithm in approved mode", parameters.getAlgorithm());
        }
        return new OutEncryptor(this, key, parameters, null);
    }

    @Override
    public OutputDecryptor<T> createOutputDecryptor(SymmetricKey key, T parameters) {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved algorithm in approved mode", parameters.getAlgorithm());
        }
        final StreamCipher cipher = this.createCipher(false, key, parameters, null);
        return new OutputDecryptor<T>((Parameters)parameters){
            final /* synthetic */ Parameters val$parameters;
            {
                this.val$parameters = parameters;
            }

            @Override
            public CipherOutputStreamImpl getDecryptingStream(OutputStream out) {
                return new CipherOutputStreamImpl(out, cipher);
            }

            @Override
            public T getParameters() {
                return this.val$parameters;
            }

            @Override
            public int getMaxOutputSize(int inputLen) {
                return inputLen;
            }

            @Override
            public int getUpdateOutputSize(int inputLen) {
                return inputLen;
            }
        };
    }

    @Override
    public final InputDecryptor<T> createInputDecryptor(SymmetricKey key, T parameters) {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Attempt to create unapproved algorithm in approved mode", parameters.getAlgorithm());
        }
        StreamCipher cipher = this.createCipher(false, key, parameters, null);
        return new InputDecryptor<T>((Parameters)parameters, cipher){
            final /* synthetic */ Parameters val$parameters;
            final /* synthetic */ StreamCipher val$cipher;
            {
                this.val$parameters = parameters;
                this.val$cipher = streamCipher;
            }

            @Override
            public T getParameters() {
                return this.val$parameters;
            }

            @Override
            public InputStream getDecryptingStream(InputStream in) {
                return new CipherInputStream(in, this.val$cipher);
            }
        };
    }

    protected abstract StreamCipher createCipher(boolean var1, SymmetricKey var2, T var3, SecureRandom var4);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OutEncryptor
    implements OutputEncryptor<T>,
    OperatorUsingSecureRandom<OutputEncryptor<T>> {
        private final T parameters;
        private final SymmetricKey key;
        private final StreamCipher cipher;
        final /* synthetic */ GuardedSymmetricStreamOperatorFactory this$0;

        public OutEncryptor(SymmetricKey key, T parameters, SecureRandom random) {
            this.this$0 = var1_1;
            this.key = key;
            this.parameters = parameters;
            this.cipher = var1_1.createCipher(true, key, parameters, random);
        }

        @Override
        public CipherOutputStream getEncryptingStream(OutputStream out) {
            return new CipherOutputStreamImpl(out, this.cipher);
        }

        @Override
        public OutputEncryptor<T> withSecureRandom(SecureRandom random) {
            return new OutEncryptor(this.this$0, this.key, this.parameters, random);
        }

        @Override
        public T getParameters() {
            return this.parameters;
        }

        @Override
        public int getMaxOutputSize(int inputLen) {
            return inputLen;
        }

        @Override
        public int getUpdateOutputSize(int inputLen) {
            return inputLen;
        }
    }
}

