/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.security.SecureRandom;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.ParametersWithIV;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsDRBG;
import org.bouncycastle.crypto.fips.FipsParameters;
import org.bouncycastle.crypto.fips.Mode;
import org.bouncycastle.crypto.fips.Padding;
import org.bouncycastle.crypto.fips.Utils;
import org.bouncycastle.crypto.internal.BlockCipher;
import org.bouncycastle.crypto.internal.BufferedBlockCipher;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.EngineProvider;
import org.bouncycastle.crypto.internal.ValidatedSymmetricKey;
import org.bouncycastle.crypto.internal.modes.AEADBlockCipher;
import org.bouncycastle.crypto.internal.modes.CBCBlockCipher;
import org.bouncycastle.crypto.internal.modes.CCMBlockCipher;
import org.bouncycastle.crypto.internal.modes.CFBBlockCipher;
import org.bouncycastle.crypto.internal.modes.GCMBlockCipher;
import org.bouncycastle.crypto.internal.modes.NISTCTSBlockCipher;
import org.bouncycastle.crypto.internal.modes.OFBBlockCipher;
import org.bouncycastle.crypto.internal.modes.SICBlockCipher;
import org.bouncycastle.crypto.internal.paddings.ISO10126d2Padding;
import org.bouncycastle.crypto.internal.paddings.ISO7816d4Padding;
import org.bouncycastle.crypto.internal.paddings.PKCS7Padding;
import org.bouncycastle.crypto.internal.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.internal.paddings.TBCPadding;
import org.bouncycastle.crypto.internal.paddings.X923Padding;
import org.bouncycastle.crypto.internal.params.ParametersWithRandom;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BlockCipherUtils {
    private static SecureRandom defaultRandomPadder;

    BlockCipherUtils() {
    }

    static BufferedBlockCipher createBlockCipher(EngineProvider<BlockCipher> provider, FipsParameters parameter) {
        BlockCipher cipher = provider.createEngine();
        Padding padding = (Padding)parameter.getAlgorithm().additionalVariation();
        switch ((Mode)parameter.getAlgorithm().basicVariation()) {
            case ECB: {
                break;
            }
            case CBC: {
                if (padding == Padding.CS1 || padding == Padding.CS2 || padding == Padding.CS3) break;
                cipher = new CBCBlockCipher(cipher);
                break;
            }
            case CFB8: {
                cipher = new CFBBlockCipher(cipher, 8);
                break;
            }
            case CFB64: {
                cipher = new CFBBlockCipher(cipher, 64);
                break;
            }
            case CFB128: {
                cipher = new CFBBlockCipher(cipher, 128);
                break;
            }
            case OFB64: {
                cipher = new OFBBlockCipher(cipher, 64);
                break;
            }
            case OFB128: {
                cipher = new OFBBlockCipher(cipher, 128);
                break;
            }
            case CTR: {
                cipher = new SICBlockCipher(cipher);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown mode passed to createBlockCipher: " + parameter.getAlgorithm());
            }
        }
        if (padding != null) {
            switch (padding) {
                case PKCS7: {
                    return new PaddedBufferedBlockCipher(cipher, new PKCS7Padding());
                }
                case ISO7816_4: {
                    return new PaddedBufferedBlockCipher(cipher, new ISO7816d4Padding());
                }
                case ISO10126_2: {
                    return new PaddedBufferedBlockCipher(cipher, new ISO10126d2Padding());
                }
                case TBC: {
                    return new PaddedBufferedBlockCipher(cipher, new TBCPadding());
                }
                case X923: {
                    return new PaddedBufferedBlockCipher(cipher, new X923Padding());
                }
                case CS1: {
                    return new NISTCTSBlockCipher(1, cipher);
                }
                case CS2: {
                    return new NISTCTSBlockCipher(2, cipher);
                }
                case CS3: {
                    return new NISTCTSBlockCipher(3, cipher);
                }
            }
            throw new IllegalArgumentException("Unknown padding passed to createBlockCipher: " + parameter.getAlgorithm());
        }
        return new BufferedBlockCipher(cipher);
    }

    static BufferedBlockCipher createStandardCipher(boolean forEncryption, ValidatedSymmetricKey key, EngineProvider<BlockCipher> engineProvider, ParametersWithIV parameters, SecureRandom random) {
        Padding padding;
        BufferedBlockCipher cipher = BlockCipherUtils.createBlockCipher(engineProvider, (FipsParameters)((Object)parameters));
        CipherParameters cipherParameters = Utils.getKeyParameter(key);
        if (parameters.getIV() != null) {
            cipherParameters = new org.bouncycastle.crypto.internal.params.ParametersWithIV(cipherParameters, parameters.getIV());
        }
        if (((FipsAlgorithm)parameters.getAlgorithm()).additionalVariation() instanceof Padding && (padding = (Padding)((FipsAlgorithm)parameters.getAlgorithm()).additionalVariation()).getBasePadding().requiresRandom() && forEncryption) {
            if (random != null) {
                cipherParameters = new ParametersWithRandom(cipherParameters, random);
            } else {
                try {
                    cipherParameters = new ParametersWithRandom(cipherParameters, CryptoServicesRegistrar.getSecureRandom());
                }
                catch (IllegalStateException e) {
                    cipherParameters = new ParametersWithRandom(cipherParameters, BlockCipherUtils.getDefaultRandomPadder());
                }
            }
        }
        cipher.init(forEncryption, cipherParameters);
        return cipher;
    }

    static AEADBlockCipher createAEADCipher(FipsAlgorithm algorithm, EngineProvider<BlockCipher> provider) {
        AEADBlockCipher cipher;
        switch ((Mode)algorithm.basicVariation()) {
            case CCM: {
                cipher = new CCMBlockCipher(provider.createEngine());
                break;
            }
            case GCM: {
                cipher = new GCMBlockCipher(provider.createEngine());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown algorithm passed to createAEADCipher: " + algorithm);
            }
        }
        return cipher;
    }

    static synchronized SecureRandom getDefaultRandomPadder() {
        if (defaultRandomPadder == null) {
            defaultRandomPadder = FipsDRBG.SHA512.fromDefaultEntropy().setPersonalizationString(Strings.toByteArray("Bouncy Castle FIPS Default Padder")).build(Pack.longToBigEndian(System.currentTimeMillis()), false);
        }
        return defaultRandomPadder;
    }
}

