/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import java.io.IOException;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricGOST3410Key;
import org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import org.bouncycastle.crypto.asymmetric.GOST3410Parameters;
import org.bouncycastle.crypto.asymmetric.KeyUtils;
import org.bouncycastle.crypto.internal.Permissions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AsymmetricECGOST3410PrivateKey
extends AsymmetricGOST3410Key<ECDomainParameters>
implements AsymmetricPrivateKey {
    private final AtomicBoolean hasBeenDestroyed = new AtomicBoolean(false);
    private int hashCode;
    private BigInteger x;

    public AsymmetricECGOST3410PrivateKey(Algorithm algorithm, GOST3410Parameters<ECDomainParameters> params, BigInteger x) {
        super(algorithm, params);
        this.x = x;
        this.hashCode = this.calculateHashCode();
    }

    public AsymmetricECGOST3410PrivateKey(Algorithm algorithm, byte[] enc) {
        this(algorithm, PrivateKeyInfo.getInstance(enc));
    }

    public AsymmetricECGOST3410PrivateKey(Algorithm algorithm, PrivateKeyInfo privateKeyInfo) {
        super(algorithm, CryptoProObjectIdentifiers.gostR3410_2001, privateKeyInfo.getPrivateKeyAlgorithm());
        this.x = AsymmetricECGOST3410PrivateKey.parsePrivateKey(privateKeyInfo);
        this.hashCode = this.calculateHashCode();
    }

    private static BigInteger parsePrivateKey(PrivateKeyInfo info) {
        try {
            ASN1Encodable keyData = info.parsePrivateKey();
            if (keyData instanceof ASN1Integer) {
                return ASN1Integer.getInstance(keyData).getPositiveValue();
            }
            byte[] encVal = ASN1OctetString.getInstance(keyData).getOctets();
            byte[] dVal = new byte[encVal.length];
            for (int i = 0; i != encVal.length; ++i) {
                dVal[i] = encVal[encVal.length - 1 - i];
            }
            return new BigInteger(1, dVal);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to parse ECGOST3410 private key: " + e.getMessage(), e);
        }
    }

    @Override
    public final byte[] getEncoded() {
        byte[] encKey = new byte[32];
        this.extractBytes(encKey, 0, this.getS());
        if (this.getParameters().getPublicKeyParamSet() != null) {
            GOST3410PublicKeyAlgParameters pubParams = new GOST3410PublicKeyAlgParameters(this.getParameters().getPublicKeyParamSet(), this.getParameters().getDigestParamSet(), this.getParameters().getEncryptionParamSet());
            return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_2001, pubParams), new DEROctetString(encKey));
        }
        return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_2001), new DEROctetString(encKey));
    }

    private void extractBytes(byte[] encKey, int offSet, BigInteger bI) {
        byte[] val = bI.toByteArray();
        if (val.length < 32) {
            byte[] tmp = new byte[32];
            System.arraycopy(val, 0, tmp, tmp.length - val.length, val.length);
            val = tmp;
        }
        for (int i = 0; i != 32; ++i) {
            encKey[offSet + i] = val[val.length - 1 - i];
        }
    }

    @Override
    public final Algorithm getAlgorithm() {
        KeyUtils.checkDestroyed(this);
        return super.getAlgorithm();
    }

    @Override
    public final GOST3410Parameters<ECDomainParameters> getParameters() {
        KeyUtils.checkDestroyed(this);
        return super.getParameters();
    }

    public BigInteger getS() {
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        KeyUtils.checkDestroyed(this);
        return this.x;
    }

    @Override
    public void destroy() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        if (!this.hasBeenDestroyed.getAndSet(true)) {
            this.x = null;
            this.hashCode = -1;
            super.zeroize();
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.hasBeenDestroyed.get();
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    private int calculateHashCode() {
        int result = this.x.hashCode();
        result = 31 * result + this.getParameters().hashCode();
        return result;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.destroy();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AsymmetricECGOST3410PrivateKey)) {
            return false;
        }
        AsymmetricECGOST3410PrivateKey other = (AsymmetricECGOST3410PrivateKey)o;
        if (this.isDestroyed() || other.isDestroyed()) {
            return false;
        }
        return this.x.equals(other.x) && this.getParameters().equals(other.getParameters());
    }
}

