/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.spec;

import java.math.BigInteger;
import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.crypto.DigestAlgorithm;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.util.Arrays;

public class DSADomainParametersGenerationParameterSpec
implements AlgorithmParameterSpec {
    public static final int DIGITAL_SIGNATURE_USAGE = 1;
    public static final int KEY_ESTABLISHMENT_USAGE = 2;
    private final int l;
    private final int n;
    private final int certainty;
    private final BigInteger p;
    private final BigInteger q;
    private final byte[] seed;
    private final int usageIndex;
    private final DigestAlgorithm digestAlgorithm;

    public DSADomainParametersGenerationParameterSpec(int L, int N, int certainty) {
        this(L, N, certainty, -1);
    }

    public DSADomainParametersGenerationParameterSpec(int L, int N, int certainty, int usageIndex) {
        this(FipsSHS.Algorithm.SHA256, L, N, certainty, null, null, null, usageIndex);
    }

    public DSADomainParametersGenerationParameterSpec(BigInteger p, BigInteger q) {
        this(FipsSHS.Algorithm.SHA256, p.bitLength(), q.bitLength(), 0, p, q, null, -1);
    }

    public DSADomainParametersGenerationParameterSpec(BigInteger p, BigInteger q, byte[] seed, int usageIndex) {
        this(FipsSHS.Algorithm.SHA256, p.bitLength(), q.bitLength(), 0, p, q, Arrays.clone(seed), usageIndex);
    }

    private DSADomainParametersGenerationParameterSpec(DigestAlgorithm digestAlgorithm, int L, int N, int certainty, BigInteger p, BigInteger q, byte[] seed, int usageIndex) {
        this.digestAlgorithm = digestAlgorithm;
        this.l = L;
        this.n = N;
        this.certainty = certainty;
        this.p = p;
        this.q = q;
        this.seed = seed;
        this.usageIndex = usageIndex;
    }

    public DSADomainParametersGenerationParameterSpec withDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
        return new DSADomainParametersGenerationParameterSpec(digestAlgorithm, this.l, this.n, this.certainty, this.p, this.q, this.seed, this.usageIndex);
    }

    public int getL() {
        return this.l;
    }

    public int getN() {
        return this.n;
    }

    public int getCertainty() {
        return this.certainty;
    }

    public int getUsageIndex() {
        return this.usageIndex;
    }

    public BigInteger getP() {
        return this.p;
    }

    public BigInteger getQ() {
        return this.q;
    }

    public byte[] getSeed() {
        return Arrays.clone(this.seed);
    }

    public DigestAlgorithm getDigestAlgorithm() {
        return this.digestAlgorithm;
    }
}

