/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RC2CBCParameter;
import org.bouncycastle.crypto.MACOperatorFactory;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.PasswordBasedDeriver;
import org.bouncycastle.crypto.PasswordConverter;
import org.bouncycastle.crypto.SymmetricKeyGenerator;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.general.RC2;
import org.bouncycastle.crypto.general.SecureHash;
import org.bouncycastle.jcajce.provider.AlgorithmProvider;
import org.bouncycastle.jcajce.provider.AuthParametersCreator;
import org.bouncycastle.jcajce.provider.BaseAlgorithmParameterGenerator;
import org.bouncycastle.jcajce.provider.BaseAlgorithmParameters;
import org.bouncycastle.jcajce.provider.BaseCipher;
import org.bouncycastle.jcajce.provider.BaseKeyGenerator;
import org.bouncycastle.jcajce.provider.BaseMac;
import org.bouncycastle.jcajce.provider.BaseSecretKeyFactory;
import org.bouncycastle.jcajce.provider.BaseWrapCipher;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.GuardedEngineCreator;
import org.bouncycastle.jcajce.provider.KeyGeneratorCreator;
import org.bouncycastle.jcajce.provider.PBEScheme;
import org.bouncycastle.jcajce.provider.ParametersCreator;
import org.bouncycastle.jcajce.provider.ParametersCreatorProvider;
import org.bouncycastle.jcajce.provider.ProvPBEPBKDF1;
import org.bouncycastle.jcajce.provider.ProvPKCS12;
import org.bouncycastle.jcajce.provider.Utils;

final class ProvRC2
extends AlgorithmProvider {
    private static final String PREFIX = ProvRC2.class.getName();
    private Class[] availableSpecs = new Class[]{RC2ParameterSpec.class, IvParameterSpec.class};
    private ParametersCreatorProvider<Parameters> generalParametersCreatorProvider = new ParametersCreatorProvider<Parameters>(){

        @Override
        public ParametersCreator get(final Parameters parameters) {
            return new ParametersCreator(){

                public Parameters createParameters(boolean forEncryption, AlgorithmParameterSpec spec, SecureRandom random) {
                    if (spec instanceof IvParameterSpec) {
                        if (Utils.isAuthMode(parameters.getAlgorithm())) {
                            return ((RC2.AuthParameters)parameters).withIV(((IvParameterSpec)spec).getIV());
                        }
                        return ((RC2.Parameters)parameters).withIV(((IvParameterSpec)spec).getIV());
                    }
                    if (spec instanceof RC2ParameterSpec) {
                        RC2ParameterSpec rc2Spec = (RC2ParameterSpec)spec;
                        if (Utils.isAuthMode(parameters.getAlgorithm())) {
                            RC2.AuthParameters params = ((RC2.AuthParameters)parameters).withEffectiveKeySizeInBits(rc2Spec.getEffectiveKeyBits());
                            if (rc2Spec.getIV() != null) {
                                return params.withIV(((RC2ParameterSpec)spec).getIV());
                            }
                            return params;
                        }
                        RC2.Parameters params = ((RC2.Parameters)parameters).withEffectiveKeySizeInBits(rc2Spec.getEffectiveKeyBits());
                        if (rc2Spec.getIV() != null) {
                            return params.withIV(((RC2ParameterSpec)spec).getIV());
                        }
                        return params;
                    }
                    if (forEncryption && parameters.getAlgorithm().requiresAlgorithmParameters()) {
                        if (Utils.isAuthMode(parameters.getAlgorithm())) {
                            return ((RC2.AuthParameters)parameters).withIV(random);
                        }
                        return ((RC2.Parameters)parameters).withIV(random);
                    }
                    return parameters;
                }
            };
        }
    };

    ProvRC2() {
    }

    public void configure(final BouncyCastleFipsProvider provider) {
        provider.addAlgorithmImplementation("AlgorithmParameterGenerator.RC2", PREFIX + "$AlgParamGen", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new AlgParamGen(provider);
            }
        }));
        provider.addAlias("AlgorithmParameterGenerator", "RC2", PKCSObjectIdentifiers.RC2_CBC);
        provider.addAlgorithmImplementation("KeyGenerator.RC2", PREFIX + "$KeyGenerator", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new BaseKeyGenerator(provider, "RC2", 128, false, new KeyGeneratorCreator(){

                    public SymmetricKeyGenerator createInstance(int keySize, SecureRandom random) {
                        return new RC2.KeyGenerator(keySize, random);
                    }
                });
            }
        }));
        provider.addAlias("KeyGenerator", "RC2", PKCSObjectIdentifiers.RC2_CBC, PKCSObjectIdentifiers.id_alg_CMSRC2wrap);
        provider.addAlgorithmImplementation("AlgorithmParameters.RC2", PREFIX + "$AlgParams", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new AlgParams();
            }
        }));
        provider.addAlias("AlgorithmParameters", "RC2", PKCSObjectIdentifiers.RC2_CBC);
        provider.addAlgorithmImplementation("Cipher.RC2", PREFIX + "$ECB", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new BaseCipher.Builder(provider, 64, RC2.ECBwithPKCS7, RC2.ECB, RC2.ECBwithISO10126_2, RC2.ECBwithISO7816_4, RC2.ECBwithTBC, RC2.ECBwithX923, RC2.CBC, RC2.CBCwithPKCS7, RC2.CBCwithISO10126_2, RC2.CBCwithISO7816_4, RC2.CBCwithTBC, RC2.CBCwithX923, RC2.CBCwithCS1, RC2.CBCwithCS2, RC2.CBCwithCS3, RC2.CFB64, RC2.CFB8, RC2.OFB, RC2.CTR, RC2.EAX).withGeneralOperators(ProvRC2.this.generalParametersCreatorProvider, new RC2.OperatorFactory(), new RC2.AEADOperatorFactory()).withParameters(ProvRC2.this.availableSpecs).build();
            }
        }));
        provider.addAlgorithmImplementation("Cipher", PKCSObjectIdentifiers.RC2_CBC, PREFIX + "$CBC", (EngineCreator)new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new BaseCipher.Builder(provider, 64, RC2.CBCwithPKCS7).withGeneralOperators(ProvRC2.this.generalParametersCreatorProvider, new RC2.OperatorFactory(), null).withParameters(ProvRC2.this.availableSpecs).build();
            }
        }));
        provider.addAlgorithmImplementation("Cipher.RC2WRAP", PREFIX + "$Wrap", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new BaseWrapCipher.Builder(provider, RC2.RFC3217_WRAP).withGeneralOperators(ProvRC2.this.generalParametersCreatorProvider, new RC2.KeyWrapOperatorFactory()).withParameters(ProvRC2.this.availableSpecs).build();
            }
        }));
        provider.addAlias("Cipher", "RC2WRAP", PKCSObjectIdentifiers.id_alg_CMSRC2wrap);
        provider.addAlgorithmImplementation("Mac.RC2MAC", PREFIX + "$CBCMAC", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new BaseMac(RC2.CBC_MAC, (MACOperatorFactory)new RC2.MACOperatorFactory(), new AuthParametersCreator(RC2.CBC_MAC));
            }
        }));
        provider.addAlias("Alg.Alias.Mac.RC2", "RC2MAC");
        provider.addAlgorithmImplementation("Mac.RC2MAC/CFB8", PREFIX + "$CFB8MAC", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new BaseMac(RC2.CFB8_MAC, (MACOperatorFactory)new RC2.MACOperatorFactory(), new AuthParametersCreator(RC2.CFB8_MAC));
            }
        }));
        provider.addAlias("Alg.Alias.Mac.RC2/CFB8", "RC2MAC/CFB8");
        provider.addAlgorithmImplementation("Cipher.PBEWITHSHAAND128BITRC2-CBC", PREFIX + "$PBEWithSHAAnd128BitRC2", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new BaseCipher.Builder(provider, 64, RC2.CBCwithPKCS7).withFixedKeySize(128).withScheme(PBEScheme.PKCS12).withGeneralOperators(ProvRC2.this.generalParametersCreatorProvider, new RC2.OperatorFactory(), null).withParameters(ProvRC2.this.availableSpecs).build();
            }
        }));
        provider.addAlgorithmImplementation("Cipher.PBEWITHSHAAND40BITRC2-CBC", PREFIX + "$PBEWithSHAAnd40BitRC2", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new BaseCipher.Builder(provider, 64, RC2.CBCwithPKCS7).withFixedKeySize(40).withScheme(PBEScheme.PKCS12).withGeneralOperators(ProvRC2.this.generalParametersCreatorProvider, new RC2.OperatorFactory(), null).withParameters(ProvRC2.this.availableSpecs).build();
            }
        }));
        provider.addAlgorithmImplementation("Cipher.PBEWITHMD5ANDRC2-CBC", PREFIX + "$PBEWithMD5", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new BaseCipher.Builder(provider, 64, RC2.CBCwithPKCS7).withGeneralOperators(ProvRC2.this.generalParametersCreatorProvider, new RC2.OperatorFactory(), null).withFixedKeySize(64).withScheme(PBEScheme.PBKDF1).withPrf(SecureHash.Algorithm.MD5).withParameters(ProvRC2.this.availableSpecs).build();
            }
        }));
        provider.addAlgorithmImplementation("Cipher.PBEWITHSHA1ANDRC2-CBC", PREFIX + "$PBEWithSHA1", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new BaseCipher.Builder(provider, 64, RC2.CBCwithPKCS7).withGeneralOperators(ProvRC2.this.generalParametersCreatorProvider, new RC2.OperatorFactory(), null).withFixedKeySize(64).withScheme(PBEScheme.PBKDF1).withPrf(FipsSHS.Algorithm.SHA1).withParameters(ProvRC2.this.availableSpecs).build();
            }
        }));
        provider.addAlias("Cipher", "PBEWITHMD5ANDRC2-CBC", PKCSObjectIdentifiers.pbeWithMD5AndRC2_CBC);
        provider.addAlias("Cipher", "PBEWITHMD5ANDRC2-CBC", "PBEWITHMD5ANDRC2");
        provider.addAlias("Cipher", "PBEWITHSHA1ANDRC2-CBC", PKCSObjectIdentifiers.pbeWithSHA1AndRC2_CBC);
        provider.addAlias("Cipher", "PBEWITHSHA1ANDRC2-CBC", "PBEWITHSHA1ANDRC2");
        provider.addAlias("Cipher", "PBEWITHSHAAND128BITRC2-CBC", PKCSObjectIdentifiers.pbeWithSHAAnd128BitRC2_CBC);
        provider.addAlias("Cipher", "PBEWITHSHAAND40BITRC2-CBC", PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC2_CBC);
        provider.addAlias("Cipher", "PBEWITHSHAAND128BITRC2-CBC", "PBEWITHSHA1AND128BITRC2-CBC");
        provider.addAlias("Cipher", "PBEWITHSHAAND40BITRC2-CBC", "PBEWITHSHA1AND40BITRC2-CBC");
        provider.addAlgorithmImplementation("SecretKeyFactory.RC2", PREFIX + "$RC2KFACT", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new BaseSecretKeyFactory("RC2", RC2.ALGORITHM, new BaseSecretKeyFactory.Validator(){

                    public byte[] validated(byte[] keyBytes) throws InvalidKeySpecException {
                        int size = keyBytes.length * 8;
                        if (size < 8 || size > 1024) {
                            throw new InvalidKeySpecException("Provided key data wrong size for RC2");
                        }
                        return keyBytes;
                    }
                });
            }
        }));
        provider.addAlgorithmImplementation("SecretKeyFactory.PBEWITHMD5ANDRC2", PREFIX + "PBEMD5RC2", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new ProvPBEPBKDF1.FixedPBKDF1("RC2", PasswordConverter.ASCII, SecureHash.Algorithm.MD5, 64);
            }
        }));
        provider.addAlgorithmImplementation("SecretKeyFactory.PBEWITHSHAANDRC2", PREFIX + "PBESHARC2", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new ProvPBEPBKDF1.FixedPBKDF1("RC2", PasswordConverter.ASCII, FipsSHS.Algorithm.SHA1, 64);
            }
        }));
        provider.addAlias("SecretKeyFactory", "PBEWITHSHAANDRC2", "PBEWITHSHA1ANDRC2", "PBEWITHSHA-1ANDRC2");
        provider.addAlgorithmImplementation("SecretKeyFactory.PBEWITHSHAAND128BITRC2", PREFIX + "PBE128RC2", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new ProvPKCS12.KeyFactory("RC2", PasswordBasedDeriver.KeyType.CIPHER, 128);
            }
        }));
        provider.addAlias("SecretKeyFactory", "PBEWITHSHAAND128BITRC2", "PBEWITHSHA1AND128BITRC2", "PBEWITHSHA-1AND128BITRC2");
        provider.addAlgorithmImplementation("SecretKeyFactory.PBEWITHSHAAND40BITRC2", PREFIX + "PBE40RC2", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object constructorParameter) {
                return new ProvPKCS12.KeyFactory("RC2", PasswordBasedDeriver.KeyType.CIPHER, 40);
            }
        }));
        provider.addAlias("SecretKeyFactory", "PBEWITHSHAAND40BITRC2", "PBEWITHSHA1AND40BITRC2", "PBEWITHSHA-1AND40BITRC2");
        provider.addAlias("AlgorithmParameters", "PBKDF-PKCS12", PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC2_CBC, PKCSObjectIdentifiers.pbeWithSHAAnd128BitRC2_CBC);
    }

    public static class AlgParamGen
    extends BaseAlgorithmParameterGenerator {
        public AlgParamGen(BouncyCastleFipsProvider fipsProvider) {
            super(fipsProvider, 128);
        }

        protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (genParamSpec instanceof RC2ParameterSpec) {
                this.strength = ((RC2ParameterSpec)genParamSpec).getEffectiveKeyBits();
                this.random = random;
                return;
            }
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for RC2 parameter generation.");
        }

        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters params;
            byte[] iv = new byte[8];
            if (this.random == null) {
                this.random = this.fipsProvider.getDefaultSecureRandom();
            }
            this.random.nextBytes(iv);
            try {
                params = AlgorithmParameters.getInstance("RC2", this.fipsProvider);
                params.init(new RC2ParameterSpec(this.strength, iv));
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
            return params;
        }
    }

    public static class AlgParams
    extends BaseAlgorithmParameters {
        private static final short[] table = new short[]{189, 86, 234, 242, 162, 241, 172, 42, 176, 147, 209, 156, 27, 51, 253, 208, 48, 4, 182, 220, 125, 223, 50, 75, 247, 203, 69, 155, 49, 187, 33, 90, 65, 159, 225, 217, 74, 77, 158, 218, 160, 104, 44, 195, 39, 95, 128, 54, 62, 238, 251, 149, 26, 254, 206, 168, 52, 169, 19, 240, 166, 63, 216, 12, 120, 36, 175, 35, 82, 193, 103, 23, 245, 102, 144, 231, 232, 7, 184, 96, 72, 230, 30, 83, 243, 146, 164, 114, 140, 8, 21, 110, 134, 0, 132, 250, 244, 127, 138, 66, 25, 246, 219, 205, 20, 141, 80, 18, 186, 60, 6, 78, 236, 179, 53, 17, 161, 136, 142, 43, 148, 153, 183, 113, 116, 211, 228, 191, 58, 222, 150, 14, 188, 10, 237, 119, 252, 55, 107, 3, 121, 137, 98, 198, 215, 192, 210, 124, 106, 139, 34, 163, 91, 5, 93, 2, 117, 213, 97, 227, 24, 143, 85, 81, 173, 31, 11, 94, 133, 229, 194, 87, 99, 202, 61, 108, 180, 197, 204, 112, 178, 145, 89, 13, 71, 32, 200, 79, 88, 224, 1, 226, 22, 56, 196, 111, 59, 15, 101, 70, 190, 126, 45, 123, 130, 249, 64, 181, 29, 115, 248, 235, 38, 199, 135, 151, 37, 84, 177, 40, 170, 152, 157, 165, 100, 109, 122, 212, 16, 129, 68, 239, 73, 214, 174, 46, 221, 118, 92, 47, 167, 28, 201, 9, 105, 154, 131, 207, 41, 57, 185, 233, 76, 255, 67, 171};
        private static final short[] ekb = new short[]{93, 190, 155, 139, 17, 153, 110, 77, 89, 243, 133, 166, 63, 183, 131, 197, 228, 115, 107, 58, 104, 90, 192, 71, 160, 100, 52, 12, 241, 208, 82, 165, 185, 30, 150, 67, 65, 216, 212, 44, 219, 248, 7, 119, 42, 202, 235, 239, 16, 28, 22, 13, 56, 114, 47, 137, 193, 249, 128, 196, 109, 174, 48, 61, 206, 32, 99, 254, 230, 26, 199, 184, 80, 232, 36, 23, 252, 37, 111, 187, 106, 163, 68, 83, 217, 162, 1, 171, 188, 182, 31, 152, 238, 154, 167, 45, 79, 158, 142, 172, 224, 198, 73, 70, 41, 244, 148, 138, 175, 225, 91, 195, 179, 123, 87, 209, 124, 156, 237, 135, 64, 140, 226, 203, 147, 20, 201, 97, 46, 229, 204, 246, 94, 168, 92, 214, 117, 141, 98, 149, 88, 105, 118, 161, 74, 181, 85, 9, 120, 51, 130, 215, 221, 121, 245, 27, 11, 222, 38, 33, 40, 116, 4, 151, 86, 223, 60, 240, 55, 57, 220, 255, 6, 164, 234, 66, 8, 218, 180, 113, 176, 207, 18, 122, 78, 250, 108, 29, 132, 0, 200, 127, 145, 69, 170, 43, 194, 177, 143, 213, 186, 242, 173, 25, 178, 103, 54, 247, 15, 10, 146, 125, 227, 157, 233, 144, 62, 35, 39, 102, 19, 236, 129, 21, 189, 34, 191, 159, 126, 169, 81, 75, 76, 251, 2, 211, 112, 134, 49, 231, 59, 5, 3, 84, 96, 72, 101, 24, 210, 205, 95, 50, 136, 14, 53, 253};
        private byte[] iv;
        private int parameterVersion = 58;

        protected byte[] localGetEncoded() throws IOException {
            if (this.parameterVersion == -1) {
                return new RC2CBCParameter(this.iv).getEncoded();
            }
            return new RC2CBCParameter(this.parameterVersion, this.iv).getEncoded();
        }

        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
            if ((paramSpec == RC2ParameterSpec.class || paramSpec == AlgorithmParameterSpec.class) && this.parameterVersion != -1) {
                if (this.parameterVersion < 256) {
                    return new RC2ParameterSpec(ekb[this.parameterVersion], this.iv);
                }
                return new RC2ParameterSpec(this.parameterVersion, this.iv);
            }
            if (paramSpec == IvParameterSpec.class) {
                return new IvParameterSpec(this.iv);
            }
            throw new InvalidParameterSpecException("AlgorithmParameterSpec not recognized: " + paramSpec.getName());
        }

        protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
            if (paramSpec instanceof IvParameterSpec) {
                this.iv = ((IvParameterSpec)paramSpec).getIV();
            } else if (paramSpec instanceof RC2ParameterSpec) {
                int effKeyBits = ((RC2ParameterSpec)paramSpec).getEffectiveKeyBits();
                if (effKeyBits != -1) {
                    this.parameterVersion = effKeyBits < 256 ? table[effKeyBits] : effKeyBits;
                }
                this.iv = ((RC2ParameterSpec)paramSpec).getIV();
            } else {
                throw new InvalidParameterSpecException("IvParameterSpec or RC2ParameterSpec required to initialise a RC2 parameters algorithm parameters object");
            }
        }

        protected void localInit(byte[] params) throws IOException {
            ASN1Primitive spec = ASN1Primitive.fromByteArray(params);
            if (spec instanceof ASN1OctetString) {
                this.iv = ASN1OctetString.getInstance(spec).getOctets();
            } else if (spec instanceof ASN1Sequence) {
                RC2CBCParameter rc2Param = RC2CBCParameter.getInstance(spec);
                this.iv = rc2Param.getIV();
                this.parameterVersion = rc2Param.getRC2ParameterVersion().intValue();
            } else {
                throw new IOException("Unable to recognize parameters");
            }
        }

        protected String engineToString() {
            return "RC2 Parameters";
        }
    }
}

